
package com.openexchange.office.json.actions;

import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.office.json.tools.RequestDataHelper;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;

/**
 * {@link RenameDocumentAction}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */

/*
 * MH/KA compilefix for buildsystem
 * @Action(method = RequestMethod.GET, name = "renamedocument", description = "Set a new filename for the given filestore document.",
 * parameters = {
 * @Parameter(name = "id", description = "Object ID of the requested infoitem."),
 * @Parameter(name = "folder_id", description = "Folder ID of the requested infoitem."),
 * @Parameter(name = "filename", description = "The new filename of the requested filestore item to be set."),
 * @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
 * @Parameter(name = "uid", description = "The unique id of the client application."),
 * @Parameter(name = "version", optional=true, description =
 * "If present, the infoitem data describes the given version. Otherwise the current version is returned.") }, responseDescription =
 * "Response with timestamp: A JSON object containing the attributes of the created filestore item: 'id', 'folder_id', 'version' and 'filename'."
 * )
 */

public class RenameDocumentAction extends DocumentFilterAction {

    /**
     * Initializes a new {@link RenameDocumentAction}.
     * @param services
     */
    public RenameDocumentAction(ServiceLookup services) {
        super(services);
    }

    /* (non-Javadoc)
     * @see com.openexchange.ajax.requesthandler.AJAXActionService#perform(com.openexchange.ajax.requesthandler.AJAXRequestData, com.openexchange.tools.session.ServerSession)
     */
    @Override
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) {
        final JSONObject requestData = new JSONObject();
        final RequestDataHelper helper = new RequestDataHelper(request);

        try {
            requestData.put("fileName", helper.getParameter("filename"));
        } catch (JSONException e) {
            //
        }

        return getAjaxRequestResult(sendConnectionMessageSynchronously(request, session, "renameDocument", "document", requestData));
    }
}
