/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/tk/forms'
], function (Forms) {

    'use strict';

    // static class Forms =====================================================

    describe('Toolkit module Forms', function () {

        it('should exist', function () {
            expect(Forms).to.be.an('object');
        });

        // constants ----------------------------------------------------------

        describe('constant "HIDDEN_CLASS"', function () {
            it('should exist', function () {
                expect(Forms.HIDDEN_CLASS).to.be.a('string');
                expect(Forms.HIDDEN_CLASS).to.not.be.empty;
            });
        });

        describe('constant "HIDDEN_SELECTOR"', function () {
            it('should exist', function () {
                expect(Forms.HIDDEN_SELECTOR).to.be.a('string');
                expect(Forms.HIDDEN_SELECTOR).to.not.be.empty;
            });
        });

        describe('constant "VISIBLE_SELECTOR"', function () {
            it('should exist', function () {
                expect(Forms.VISIBLE_SELECTOR).to.be.a('string');
                expect(Forms.VISIBLE_SELECTOR).to.not.be.empty;
            });
        });

        describe('constant "DISABLED_CLASS"', function () {
            it('should exist', function () {
                expect(Forms.DISABLED_CLASS).to.be.a('string');
                expect(Forms.DISABLED_CLASS).to.not.be.empty;
            });
        });

        describe('constant "DISABLED_SELECTOR"', function () {
            it('should exist', function () {
                expect(Forms.DISABLED_SELECTOR).to.be.a('string');
                expect(Forms.DISABLED_SELECTOR).to.not.be.empty;
            });
        });

        describe('constant "ENABLED_SELECTOR"', function () {
            it('should exist', function () {
                expect(Forms.ENABLED_SELECTOR).to.be.a('string');
                expect(Forms.ENABLED_SELECTOR).to.not.be.empty;
            });
        });

        describe('constant "SELECTED_CLASS"', function () {
            it('should exist', function () {
                expect(Forms.SELECTED_CLASS).to.be.a('string');
                expect(Forms.SELECTED_CLASS).to.not.be.empty;
            });
        });

        describe('constant "SELECTED_SELECTOR"', function () {
            it('should exist', function () {
                expect(Forms.SELECTED_SELECTOR).to.be.a('string');
                expect(Forms.SELECTED_SELECTOR).to.not.be.empty;
            });
        });

        describe('constant "FOCUSED_CLASS"', function () {
            it('should exist', function () {
                expect(Forms.FOCUSED_CLASS).to.be.a('string');
                expect(Forms.FOCUSED_CLASS).to.not.be.empty;
            });
        });

        describe('constant "FOCUSABLE_SELECTOR"', function () {
            it('should exist', function () {
                expect(Forms.FOCUSABLE_SELECTOR).to.be.a('string');
                expect(Forms.FOCUSABLE_SELECTOR).to.not.be.empty;
            });
        });

        describe('constant "BUTTON_CLASS"', function () {
            it('should exist', function () {
                expect(Forms.BUTTON_CLASS).to.be.a('string');
                expect(Forms.BUTTON_CLASS).to.not.be.empty;
            });
        });

        describe('constant "BUTTON_SELECTOR"', function () {
            it('should exist', function () {
                expect(Forms.BUTTON_SELECTOR).to.be.a('string');
                expect(Forms.BUTTON_SELECTOR).to.not.be.empty;
            });
        });

        // static methods -----------------------------------------------------

        describe('method "addDeviceMarkers"', function () {
            it('should exist', function () {
                expect(Forms).itself.to.respondTo('addDeviceMarkers');
            });
            it('should add browser-specific classes to a node', function () {
                var node = $('<div class="test">');
                Forms.addDeviceMarkers(node);
                var classes = node.attr('class').split(/\s+/).filter(function (cls) { return (/^browser-/).test(cls); });
                expect(classes).to.have.length.at.least(1);
            });
        });

        describe('method "createLoggingTooltipMarkup"', function () {
            it('should exist', function () {
                expect(Forms).itself.to.respondTo('createLoggingTooltipMarkup');
            });
            function format(expected) {
                return expected.replace(/~/g, '&nbsp; &nbsp; ').replace(/\|/g, '&#10;').replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/\//g, '&#47;');
            }
            it('should convert atomic data types', function () {
                expect(Forms.createLoggingTooltipMarkup(undefined)).to.equal('undefined');
                expect(Forms.createLoggingTooltipMarkup(null)).to.equal('null');
                expect(Forms.createLoggingTooltipMarkup(false)).to.equal('false');
                expect(Forms.createLoggingTooltipMarkup(true)).to.equal('true');
                expect(Forms.createLoggingTooltipMarkup(0)).to.equal('0');
                expect(Forms.createLoggingTooltipMarkup(42)).to.equal('42');
            });
            it('should convert strings', function () {
                expect(Forms.createLoggingTooltipMarkup('')).to.equal(format('""'));
                expect(Forms.createLoggingTooltipMarkup('abc')).to.equal(format('"abc"'));
                expect(Forms.createLoggingTooltipMarkup('<abc>')).to.equal(format('"&lt;abc&gt;"'));
                expect(Forms.createLoggingTooltipMarkup('"abc"')).to.equal(format('"\\"abc\\""'));
                expect(Forms.createLoggingTooltipMarkup('\'abc\'')).to.equal(format('"\'abc\'"'));
                expect(Forms.createLoggingTooltipMarkup('abc\ndef')).to.equal(format('String [2]|~0: "abc"|~1: "def"'));
            });
            it('should convert regular expressions', function () {
                expect(Forms.createLoggingTooltipMarkup(/abc/)).to.equal(format('/abc/'));
                expect(Forms.createLoggingTooltipMarkup(/^abc$/i)).to.equal(format('/^abc$/i'));
            });
            it('should convert objects', function () {
                expect(Forms.createLoggingTooltipMarkup({})).to.equal('Object');
                expect(Forms.createLoggingTooltipMarkup({ a: 1 })).to.equal(format('Object|~a: 1'));
                expect(Forms.createLoggingTooltipMarkup({ '"': 1 })).to.equal(format('Object|~\\": 1'));
                expect(Forms.createLoggingTooltipMarkup({ a: 1, b: 'abc' })).to.satisfy(function (result) {
                    var a = format('|~a: 1'), b = format('|~b: "abc"');
                    return (result === 'Object' + a + b) || (result === 'Object' + b + a);
                });
                expect(Forms.createLoggingTooltipMarkup({ a: 1, b: { c: 2 } })).to.satisfy(function (result) {
                    var a = format('|~a: 1'), b = format('|~b: Object|~~c: 2');
                    return (result === 'Object' + a + b) || (result === 'Object' + b + a);
                });
            });
            it('should convert arrays', function () {
                expect(Forms.createLoggingTooltipMarkup([])).to.equal('[]');
                expect(Forms.createLoggingTooltipMarkup([undefined, null, true, 42])).to.equal('[undefined, null, true, 42]');
                expect(Forms.createLoggingTooltipMarkup([1, 2, 3, 4, 5, 6, 7, 8])).to.equal('[1, 2, 3, 4, 5, 6, 7, 8]');
                expect(Forms.createLoggingTooltipMarkup([0, 1, 2, 3, 4, 5, 6, 7, 8])).to.equal(format('Array [9]|~0: 0|~1: 1|~2: 2|~3: 3|~4: 4|~5: 5|~6: 6|~7: 7|~8: 8'));
                expect(Forms.createLoggingTooltipMarkup(['abc'])).to.equal(format('Array [1]|~0: "abc"'));
                expect(Forms.createLoggingTooltipMarkup([/abc/])).to.equal(format('Array [1]|~0: /abc/'));
                expect(Forms.createLoggingTooltipMarkup([1, [2, 3]])).to.equal(format('Array [2]|~0: 1|~1: [2, 3]'));
                expect(Forms.createLoggingTooltipMarkup([1, [2, 'abc']])).to.equal(format('Array [2]|~0: 1|~1: Array [2]|~~0: 2|~~1: "abc"'));
            });
            it('should convert mixed objects and arrays', function () {
                expect(Forms.createLoggingTooltipMarkup([1, { a: 2 }])).to.equal(format('Array [2]|~0: 1|~1: Object|~~a: 2'));
                expect(Forms.createLoggingTooltipMarkup([1, { a: [2, 3] }])).to.equal(format('Array [2]|~0: 1|~1: Object|~~a: [2, 3]'));
                expect(Forms.createLoggingTooltipMarkup([1, { a: [2, 'abc'] }])).to.equal(format('Array [2]|~0: 1|~1: Object|~~a: Array [2]|~~~0: 2|~~~1: "abc"'));
                expect(Forms.createLoggingTooltipMarkup({ a: [1, 2] })).to.equal(format('Object|~a: [1, 2]'));
                expect(Forms.createLoggingTooltipMarkup({ a: [1, 'abc'] })).to.equal(format('Object|~a: Array [2]|~~0: 1|~~1: "abc"'));
                expect(Forms.createLoggingTooltipMarkup({ a: [1, { b: 2 }] })).to.equal(format('Object|~a: Array [2]|~~0: 1|~~1: Object|~~~b: 2'));
            });
            it('should accept functions', function () {
                function f0() {}
                function f2(a, b) { a += b; }
                expect(Forms.createLoggingTooltipMarkup(f0)).to.equal('Function [0]');
                expect(Forms.createLoggingTooltipMarkup(f2)).to.equal('Function [2]');
                expect(Forms.createLoggingTooltipMarkup({ a: f0 })).to.equal(format('Object|~a: Function [0]'));
                expect(Forms.createLoggingTooltipMarkup([1, f0])).to.equal(format('Array [2]|~0: 1|~1: Function [0]'));
            });
        });
    });

    // ========================================================================
});
