/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define([
    'io.ox/office/text/dom'
], function (DOM) {

    'use strict';

    // static class DOM =======================================================

    describe('Text module DOM', function () {

        it('should exist', function () {
            expect(DOM).to.be.an('object');
        });

        // static methods -----------------------------------------------------

        describe('method "isTableRowNode"', function () {
            it('should exist', function () {
                expect(DOM).itself.to.respondTo('isTableRowNode');
            });
            it('should find valid table row nodes', function () {
                expect(DOM.isTableRowNode($('<tr>'))).to.equal(true);
                expect(DOM.isTableRowNode($('<td>'))).not.to.equal(true);
            });
        });

        describe('method "isListLabelNode"', function () {
            it('should exist', function () {
                expect(DOM).itself.to.respondTo('isListLabelNode');
            });
            it('should find valid list label nodes', function () {
                expect(DOM.isListLabelNode($('<div>').addClass('list-label'))).to.equal(true);
                expect(DOM.isListLabelNode($('<span>').addClass('list-label'))).not.to.equal(true);
                expect(DOM.isListLabelNode($('<div>'))).not.to.equal(true);
            });
        });
    });

    // ========================================================================
});
