/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/spreadsheet/utils/operations'
], function (Operations) {

    'use strict';

    // static class Operations ================================================

    describe('Spreadsheet module Operations', function () {

        it('should exist', function () {
            expect(Operations).to.be.an('object');
        });

        // private helpers ----------------------------------------------------

        function checkOperationName(propertyName, operationName) {
            it('"' + propertyName + '" should exist', function () {
                expect(Operations[propertyName]).to.equal(operationName);
            });
        }

        // constants ----------------------------------------------------------

        describe('constant', function () {
            checkOperationName('NOOP', 'noOp'); // include EditFramework operations
            checkOperationName('INSERT_SHEET', 'insertSheet');
            checkOperationName('DELETE_SHEET', 'deleteSheet');
            checkOperationName('CHANGE_SHEET', 'setSheetAttributes');
            checkOperationName('RENAME_SHEET', 'setSheetName');
            checkOperationName('MOVE_SHEET', 'moveSheet');
            checkOperationName('COPY_SHEET', 'copySheet');
            checkOperationName('INSERT_NAME', 'insertName');
            checkOperationName('CHANGE_NAME', 'changeName');
            checkOperationName('DELETE_NAME', 'deleteName');
            checkOperationName('INSERT_TABLE', 'insertTable');
            checkOperationName('CHANGE_TABLE', 'changeTable');
            checkOperationName('DELETE_TABLE', 'deleteTable');
            checkOperationName('CHANGE_TABLE_COLUMN', 'changeTableColumn');
            checkOperationName('INSERT_VALIDATION', 'insertValidation');
            checkOperationName('CHANGE_VALIDATION', 'changeValidation');
            checkOperationName('DELETE_VALIDATION', 'deleteValidation');
            checkOperationName('INSERT_COND_FORMAT', 'insertCondFormat');
            checkOperationName('CHANGE_COND_FORMAT', 'changeCondFormat');
            checkOperationName('DELETE_COND_FORMAT', 'deleteCondFormat');
            checkOperationName('INSERT_COND_FORMAT_RULE', 'insertCondFormatRule');
            checkOperationName('CHANGE_COND_FORMAT_RULE', 'changeCondFormatRule');
            checkOperationName('DELETE_COND_FORMAT_RULE', 'deleteCondFormatRule');
            checkOperationName('INSERT_COLUMNS', 'insertColumns');
            checkOperationName('DELETE_COLUMNS', 'deleteColumns');
            checkOperationName('CHANGE_COLUMNS', 'setColumnAttributes');
            checkOperationName('INSERT_ROWS', 'insertRows');
            checkOperationName('DELETE_ROWS', 'deleteRows');
            checkOperationName('CHANGE_ROWS', 'setRowAttributes');
            checkOperationName('INSERT_CELLS', 'insertCells');
            checkOperationName('DELETE_CELLS', 'deleteCells');
            checkOperationName('MERGE_CELLS', 'mergeCells');
            checkOperationName('SET_CELL_CONTENTS', 'setCellContents');
            checkOperationName('FILL_CELL_RANGE', 'fillCellRange');
            checkOperationName('CLEAR_CELL_RANGE', 'clearCellRange');
            checkOperationName('AUTO_FILL', 'autoFill');
        });
    });

    // ========================================================================
});
