/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    grunt.config.extend('karma', {
        options: {
            configFile: 'karma.conf.js',
            builddir: 'build/'
        },
        // starts the server for unit tests
        serve: {
            background: false,
            autoWatch: false
        },
        // executes unit tests (with console output)
        unit: {
            background: true,
            autoWatch: false
        },
        // headless mode: run tests once in PhantomJS browser with output in console
        headless: {
            singleRun: true,
            browsers: ['PhantomJS'],
            reporters: ['progress']
        },
        // continuous integration mode: run tests once in PhantomJS browser without console-output
        continuous: {
            singleRun: true,
            browsers: ['PhantomJS'],
            reporters: ['junit', 'coverage'],
            junitReporter: {
                outputFile: 'test-results.xml'
            },
            preprocessors: {
                'apps/**/*.js': ['coverage']
            },
            coverageReporter: {
                dir: 'coverage-reports',
                reporters: [
                    { type: 'cobertura', subdir: '.', file: 'cobertura.xml' },
                    { type: 'html', subdir: 'html/' }
                ]
            }
        },
        // coverage mode: run complete code coverage check without console-output
        coverage: {
            background: false,
            autoWatch: false,
            singleRun: true,
            browsers: ['PhantomJS'],
            reporters: ['coverage'],
            preprocessors: {
                'apps/**/*.js': ['coverage']
            },
            coverageReporter: {
                dir: 'coverage-reports',
                reporters: [
                    { type: 'cobertura', subdir: '.', file: 'cobertura.xml' },
                    { type: 'html', subdir: 'html/' }
                ]
            }
        }
    });

    grunt.registerTask('test', 'basic test runner', function (task, option) {
        switch (task) {
            case 'coverage':
                grunt.task.run('karma:' + task);
                break;
            case 'continuous':
                grunt.task.run('karma:continuous');
                break;

            case 'manually':
            case 'watcher':
                if (option === 'serve') {
                    grunt.task.run('karma:serve');
                } else {
                    var done = this.async(),
                        net = require('net'),
                        server = net.createServer();

                    server.on('error', function () {
                        grunt.log.writeln('Karma server running, running specs');
                        grunt.config.set('karma.options.task', 'TEST');
                        grunt.task.run('karma:unit:run');
                        done();
                    });

                    server.listen(9876, function () {
                        grunt.log.warn('No karma server running, skipping specs');
                        server.close();
                        done();
                    });
                }
                break;

            default:
                if (task && grunt.file.exists('spec/test-' + task + '.js')) {
                    grunt.config.set('karma.headless.options.files', [
                        '../node_modules/underscore/underscore.js',
                        '../bower_components/jquery/dist/jquery.js',
                        'spec/lib/**/*.js',
                        'spec/test-' + task + '.js',
                        { pattern: 'apps/**/*.{js,json}', included: false },
                        { pattern: 'spec/**/*_spec.js', included: false }
                    ]);
                }
                grunt.task.run('karma:headless');
                break;
        }
    });

    grunt.loadNpmTasks('grunt-karma');
};
