/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/view/view',
[
    'io.ox/office/tk/utils',
    'io.ox/office/editframework/view/editview',
    'less!io.ox/office/presentation/view/style'
], function (Utils, EditView) {

    'use strict';

    // class PresentationView =================================================

    /**
     * @constructor
     *
     * @extends EditView
     */
    function PresentationView(app, docModel) {

        // base constructor ---------------------------------------------------

        EditView.call(this, app, docModel, searchHandler, {
            initHandler: initHandler,
            initDebugHandler: initDebugHandler,
            initGuiHandler: initGuiHandler,
            initDebugGuiHandler: initDebugGuiHandler
        });

        // private methods ----------------------------------------------------

        /**
         * Initialization after construction.
         */
        function initHandler() {
        }

        /**
         * Additional debug initialization after construction.
         */
        function initDebugHandler(/*operationsPane, clipboardPane*/) {
        }

        /**
         * Initialization after importing the document. Creates all tool boxes
         * in the side pane and overlay pane. Needed to be executed after
         * import, to be able to hide specific GUI elements depending on the
         * file type.
         */
        function initGuiHandler(/*viewMenuGroup*/) {
        }

        /**
         * Additional initialization of debug GUI after importing the document.
         */
        function initDebugGuiHandler(/*viewMenuGroup, actionMenuGroup*/) {
        }

        /**
         * Executes a search/replace operation, as requested by the base class
         * EditView.
         */
        function searchHandler(command/*, settings*/) {
            Utils.error('PresentationView.searchHandler(): unsupported search command "' + command + '"');
            return 'internal';
        }

        // methods ------------------------------------------------------------

    } // class PresentationView

    // exports ================================================================

    // derive this class from class EditView
    return EditView.extend({ constructor: PresentationView });

});
