/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/portal/view/tooltip', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/forms',
    'io.ox/office/tk/popup/tooltip'
], function (Utils, Forms, ToolTip) {

    'use strict';

    // class Tooltip ==========================================================

    var SELECTOR = '[data-toggle]';

    function Tooltip (rootNode) {

        if (Utils.TOUCHDEVICE) { return; }

        var popup = new ToolTip({
            anchorAlign: 'center',
            anchorBorder: 'top bottom',
            classes: 'bootstraptooltip'
        });

        // private methods ----------------------------------------------------

        function mouseEnter(evt) {
            var holder = $(evt.target);
            if (!holder.is(SELECTOR)) {
                holder = $(evt.currentTarget);
            }

            popup.setAnchor(holder);
            popup.setText(holder.attr('title'));
            popup.show();

            var node = popup.getNode();
            var arrow = node.find('.arrow');

            var holderOffset = holder.offset();
            var popupOffset = node.offset();

            arrow.css('left', Math.round(holderOffset.left - popupOffset.left + holder.width() / 2) + 'px');

            arrow.toggleClass('on-top', holderOffset.top > popupOffset.top);

        }

        function mouseLeave() {
            popup.hide();
        }

        function visibleStateHandler(visible) {
            mouseLeave();

            var onOff = visible ? 'on' : 'off';

            rootNode[onOff]('mouseenter', SELECTOR, mouseEnter);
            rootNode[onOff]('mouseleave mouseup', SELECTOR, mouseLeave);
        }

        // public methods -----------------------------------------------------

        // initialization -----------------------------------------------------

        var node = popup.getNode();
        var arrow = $('<div class="arrow">');
        node.append(arrow);

        visibleStateHandler(true);

    } // class Tooltip

    // exports ================================================================

    return Tooltip;

});
