/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

/**
 *  Defines extensions and actions of the recent documents pane
 */
define('io.ox/office/portal/action/recentsactions', [
    'io.ox/core/extensions',
    'io.ox/core/extPatterns/links',
    'io.ox/core/extPatterns/actions',
    'io.ox/office/portal/portalutils'
], function (Ext, Links, CoreActions, PortalUtils) {

    'use strict';

    function RecentsExtensions() {

        var recentDocumentExtension = 'io.ox/portal/office/recents/document';

        this.documentPoint = Ext.point(recentDocumentExtension);

        new Links.Action(recentDocumentExtension + '/open', {

            action: function (baton) {
                var appModuleName = PortalUtils.getModuleNameForFile(baton.data.filename);

                PortalUtils.trackEvent({ moduleName: appModuleName, target: 'recentlist', action: 'edit' });

                ox.launch(appModuleName + '/main', { action: 'load', file: baton.data });
                //FIXME: TODO: combine me with normal file-actions
            }

        });

        this.documentPoint.extend({

            id: 'recent_document',

            draw: function (baton) {

                var link = $('<a>').addClass('document-link row')
                    .attr({
                        'data-toggle': 'tooltip',
                        title: _.noI18n(baton.data.filename),
                        tabindex: 0
                    }),
                    metadata = $('<div>').addClass('document-metadata'),
                    name = $('<div>').addClass('document-name col-xs-8'),
                    date = $('<div>').addClass('document-date col-xs-4')
                        .text(_.noI18n(PortalUtils.formatDate(baton.data.last_modified ? baton.data.last_modified : baton.data.last_opened)));

                name.append(PortalUtils.createDocumentIcon(baton.data.filename), $('<div>').text(_.noI18n(baton.data.filename)));
                link.append(metadata.append(name, date));

                link.click(function () {
                    CoreActions.invoke(recentDocumentExtension + '/open', this, baton);
                });

                link.on('keydown', PortalUtils.keydownHandler);

                this.append(link);
            }

        });

    } // class RecentExtensions

    return new RecentsExtensions();

});
