/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

(function () {

    'use strict';

    // our own busy method implementation
    $.fn.busy = function () {};

    /**
     * Replacement for a core application for unit tests. Mimics the public API
     * of an application object as returned by the method ox.ui.createApp().
     *
     * @constructor
     */
    function CoreApplication(options) {

        var appWindow = null,
            launcher = null;

        this.getName = _.constant(options.name);
        this.setTitle = _.noop;

        this.getWindow = function () { return appWindow; };
        this.getWindowNode = function () { return appWindow.nodes.main; };
        this.setWindow = function (appWin) { appWindow = appWin; };

        this.setLauncher = function (callback) { launcher = callback; };
        this.launch = function () { return $.when(launcher()); };

        this.setQuit = _.noop;
        this.quit = _.noop;

        this.registerWindowResizeHandler = _.noop;
    }

    /**
     * Replacement for the global 'window.ox' object for unit tests.
     */
    window.ox = {
        base: 'v=7.x.x.20150511.070854',
        on: _.noop,
        language: 'de_DE',
        ui: {
            createApp: function (options) {
                return new CoreApplication(options);
            },
            createWindow: function () {
                var appWin = $({});
                appWin.nodes = {
                    main: $('<div>'),
                    outer: $('<div>')
                };
                appWin.state = {
                    visible: true
                };
                appWin.setTitle = _.noop;
                appWin.busy = _.noop;
                appWin.idle = _.noop;
                return appWin;
            },
            App: {
                getCurrentWindow: _.constant(null)
            }
        },
        test: {
            launchBaseApp: function (Application, Model, View, Controller) {
                function importHandler() { return $.when(); }
                var app = new CoreApplication({ name: 'io.ox/office/baseframework' });
                Application.call(app, Model, View, Controller, importHandler, { action: 'new' });
                app.launch();
                return app;
            },
            launchApp: function (module, Application) {
                var app = new CoreApplication(module);
                Application.call(app, { action: 'new' });
                app.launch();
                return app;
            },
            DummyApplication: function () {
                this.onImportStart = _.noop;
                this.isImportFinished = _.constant(true);
                this.getImportPromise = $.when;
                this.onImportSuccess = _.noop;
                this.onInitLocale = _.noop;
                this.getFileFormat = _.constant('ooxml');
                this.isOOXML = _.constant(true);
                this.isODF = _.constant(false);
            },
            DummyTextApplication: function () {
                ox.test.DummyApplication.call(this);
            },
            DummySpreadsheetApplication: function () {
                ox.test.DummyApplication.call(this);
            },
            DummyPresentationApplication: function () {
                ox.test.DummyApplication.call(this);
            }
        }
    };

}());
