/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'json!io.ox/office/tk/locale/localedata'
], function (LOCALE_DATA) {

    'use strict';

    // LocaleData JSON data ===================================================

    describe('Toolkit JSON locale data', function () {

        it('should exist', function () {
            expect(LOCALE_DATA).to.be.an('object');
            expect(LOCALE_DATA).to.not.be.empty;
        });

        // contents -----------------------------------------------------------

        describe('language entry', function () {
            it('en_US should exist', function () {
                expect(LOCALE_DATA).to.have.a.property('en_US');
            });
            it('de_DE should exist', function () {
                expect(LOCALE_DATA).to.have.a.property('de_DE');
            });
            _.each(LOCALE_DATA, function (data, locale) {
                describe(locale, function () {
                    it('should have a valid locale code', function () {
                        expect(locale).to.match(/^[a-z]{2,}_[A-Z]{2,}$/);
                    });
                    it('should not be empty', function () {
                        expect(data).to.be.an('object');
                        expect(data).to.not.be.empty;
                    });
                    it('should contain a valid MS locale identifier', function () {
                        expect(data).to.have.a.property('lcid').that.is.a('number');
                        expect(data.lcid).to.be.above(0);
                    });
                    it('should contain a valid decimal separator', function () {
                        expect(data).to.have.a.property('dec').that.is.a('string');
                        expect(data.dec).to.have.length(1);
                    });
                    it('should contain a valid group separator', function () {
                        expect(data).to.have.a.property('group').that.is.a('string');
                        expect(data.group).to.have.length(1);
                    });
                    it('should contain a valid writing direction', function () {
                        expect(data).to.have.a.property('dir').that.is.a('string');
                        expect(data.dir).to.match(/^(ltr|rtl)$/);
                    });
                    it('should contain a valid CJK flag', function () {
                        if ('cjk' in data) { expect(data.cjk).to.equal(true); }
                    });
                    it('should contain a valid measurement unit', function () {
                        expect(data).to.have.a.property('unit').that.is.a('string');
                        expect(data.unit).to.match(/^(cm|mm|in)$/);
                    });
                    it('should contain a valid currency symbol', function () {
                        expect(data).to.have.a.property('currency').that.is.a('string');
                        expect(data.currency).to.have.length.at.least(1);
                    });
                    it('should contain a valid short date format', function () {
                        expect(data).to.have.a.property('shortDate').that.is.a('string');
                        expect(data.shortDate).to.have.length.at.least(1);
                    });
                    it('should contain a valid long date format', function () {
                        expect(data).to.have.a.property('longDate').that.is.a('string');
                        expect(data.longDate).to.have.length.at.least(1);
                    });
                    it('should contain a valid short time format', function () {
                        expect(data).to.have.a.property('shortTime').that.is.a('string');
                        expect(data.shortTime).to.have.length.at.least(1);
                    });
                    it('should contain a valid long time format', function () {
                        expect(data).to.have.a.property('longTime').that.is.a('string');
                        expect(data.longTime).to.have.length.at.least(1);
                    });
                });
            });
        });
    });

    // ========================================================================
});
