/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/control/namedrangesmenubutton', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/button',
    'io.ox/office/baseframework/view/control/compoundsplitbutton',
    'gettext!io.ox/office/spreadsheet/main'
], function (Utils, Button, CompoundSplitButton, gt) {

    'use strict';

    // class NamedRangesMenuButton ============================================

    /**
     * A compound button providing a shortcut to show the floating menu for all
     * defined names in the document, and a drop-down menu with additional
     * options.
     *
     * @constructor
     *
     * @extends CompoundSplitButton
     */
    function NamedRangesMenuButton(docView) {

        // base constructor ---------------------------------------------------

        CompoundSplitButton.call(this, docView, Utils.extendOptions({
            label: gt.pgettext('named ranges', 'Named ranges'),
            tooltip: gt.pgettext('named ranges', 'Show or hide the named ranges in this document'),
            toggle: true,
            value: 'toggle'
        }));

        // initialization -----------------------------------------------------

        // create all drop-down menu items
        this.addGroup('name/insert/dialog', new Button({ icon: 'fa-plus', label: gt.pgettext('named ranges', 'Add new range'), tooltip: gt.pgettext('named ranges', 'Add a named range') }));

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docView = null;
        });

    } // class NamedRangesMenuButton

    // exports ================================================================

    // derive this class from class CompoundSplitButton
    return CompoundSplitButton.extend({ constructor: NamedRangesMenuButton });

});
