/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/formula/impl/financialfuncs', function () {

    'use strict';

    /**************************************************************************
     *
     * This module implements all financial spreadsheet functions.
     *
     * See the README file in this directory for a detailed documentation about
     * the format of function descriptor objects.
     *
     *************************************************************************/

    // exports ================================================================

    return {

        ACCRINT: {
            category: 'financial',
            minParams: 6,
            maxParams: 8,
            type: 'val'
        },

        ACCRINTM: {
            category: 'financial',
            minParams: 4,
            maxParams: 5,
            type: 'val'
        },

        AMORDEGRC: {
            category: 'financial',
            minParams: 6,
            maxParams: 7,
            type: 'val'
        },

        AMORLINC: {
            category: 'financial',
            minParams: 6,
            maxParams: 7,
            type: 'val'
        },

        COUPDAYBS: {
            category: 'financial',
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        COUPDAYS: {
            category: 'financial',
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        COUPDAYSNC: {
            category: 'financial',
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        COUPNCD: {
            category: 'financial',
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        COUPNUM: {
            category: 'financial',
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        COUPPCD: {
            category: 'financial',
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        CUMIPMT: {
            category: 'financial',
            minParams: 6,
            maxParams: 6,
            type: 'val'
        },

        CUMPRINC: {
            category: 'financial',
            minParams: 6,
            maxParams: 6,
            type: 'val'
        },

        DB: {
            category: 'financial',
            minParams: 4,
            maxParams: 5,
            type: 'val'
        },

        DDB: {
            category: 'financial',
            minParams: 4,
            maxParams: 5,
            type: 'val'
        },

        DISC: {
            category: 'financial',
            minParams: 4,
            maxParams: 5,
            type: 'val'
        },

        DOLLARDE: {
            category: 'financial',
            minParams: 2,
            maxParams: 2,
            type: 'val'
        },

        DOLLARFR: {
            category: 'financial',
            minParams: 2,
            maxParams: 2,
            type: 'val'
        },

        DURATION: {
            category: 'financial',
            minParams: 5,
            maxParams: 6,
            type: 'val'
        },

        EFFECT: {
            category: 'financial',
            supported: 'ooxml', // ODF name: EFFECTIVE
            minParams: 2,
            maxParams: 2,
            type: 'val'
        },

        EFFECTIVE: {
            category: 'financial',
            supported: 'odf', // OOXML name: EFFECT
            minParams: 2,
            maxParams: 2,
            type: 'val'
        },

        EUROCONVERT: {
            category: 'financial',
            supported: 'odf',
            minParams: 3,
            maxParams: 4,
            type: 'val'
        },

        FV: {
            category: 'financial',
            minParams: 3,
            maxParams: 5,
            type: 'val'
        },

        FVSCHEDULE: {
            category: 'financial',
            minParams: 2,
            maxParams: 2,
            type: 'val'
        },

        INTRATE: {
            category: 'financial',
            minParams: 4,
            maxParams: 5,
            type: 'val'
        },

        IPMT: {
            category: 'financial',
            minParams: 4,
            maxParams: 6,
            type: 'val'
        },

        IRR: {
            category: 'financial',
            minParams: 1,
            maxParams: 2,
            type: 'val'
        },

        ISPMT: {
            category: 'financial',
            minParams: 4,
            maxParams: 4,
            type: 'val'
        },

        MDURATION: {
            category: 'financial',
            minParams: 5,
            maxParams: 6,
            type: 'val'
        },

        MIRR: {
            category: 'financial',
            minParams: 3,
            maxParams: 3,
            type: 'val'
        },

        NOMINAL: {
            category: 'financial',
            minParams: 2,
            maxParams: 2,
            type: 'val'
        },

        NPER: {
            category: 'financial',
            minParams: 3,
            maxParams: 5,
            type: 'val'
        },

        NPV: {
            category: 'financial',
            minParams: 2,
            type: 'val'
        },

        ODDFPRICE: {
            category: 'financial',
            minParams: 8,
            maxParams: 9,
            type: 'val'
        },

        ODDFYIELD: {
            category: 'financial',
            minParams: 8,
            maxParams: 9,
            type: 'val'
        },

        ODDLPRICE: {
            category: 'financial',
            minParams: 7,
            maxParams: 8,
            type: 'val'
        },

        ODDLYIELD: {
            category: 'financial',
            minParams: 7,
            maxParams: 8,
            type: 'val'
        },

        PDURATION: {
            category: 'financial',
            minParams: 3,
            maxParams: 3,
            type: 'val'
        },

        PMT: {
            category: 'financial',
            minParams: 3,
            maxParams: 5,
            type: 'val'
        },

        PPMT: {
            category: 'financial',
            minParams: 4,
            maxParams: 6,
            type: 'val'
        },

        PRICE: {
            category: 'financial',
            minParams: 6,
            maxParams: 7,
            type: 'val'
        },

        PRICEDISC: {
            category: 'financial',
            minParams: 4,
            maxParams: 5,
            type: 'val'
        },

        PRICEMAT: {
            category: 'financial',
            minParams: 5,
            maxParams: 6,
            type: 'val'
        },

        PV: {
            category: 'financial',
            minParams: 3,
            maxParams: 5,
            type: 'val'
        },

        RATE: {
            category: 'financial',
            minParams: 3,
            maxParams: 6,
            type: 'val'
        },

        RECEIVED: {
            category: 'financial',
            minParams: 4,
            maxParams: 5,
            type: 'val'
        },

        RRI: {
            category: 'financial',
            minParams: 3,
            maxParams: 3,
            type: 'val'
        },

        SLN: {
            category: 'financial',
            minParams: 3,
            maxParams: 3,
            type: 'val'
        },

        SYD: {
            category: 'financial',
            minParams: 4,
            maxParams: 4,
            type: 'val'
        },

        TBILLEQ: {
            category: 'financial',
            minParams: 3,
            maxParams: 3,
            type: 'val'
        },

        TBILLPRICE: {
            category: 'financial',
            minParams: 3,
            maxParams: 3,
            type: 'val'
        },

        TBILLYIELD: {
            category: 'financial',
            minParams: 3,
            maxParams: 3,
            type: 'val'
        },

        VDB: {
            category: 'financial',
            minParams: 5,
            maxParams: 7,
            type: 'val'
        },

        XIRR: {
            category: 'financial',
            minParams: 2,
            maxParams: 3,
            type: 'val'
        },

        XNPV: {
            category: 'financial',
            minParams: 3,
            maxParams: 3,
            type: 'val'
        },

        YIELD: {
            category: 'financial',
            minParams: 6,
            maxParams: 7,
            type: 'val'
        },

        YIELDDISC: {
            category: 'financial',
            minParams: 4,
            maxParams: 5,
            type: 'val'
        },

        YIELDMAT: {
            category: 'financial',
            minParams: 5,
            maxParams: 6,
            type: 'val'
        }
    };

});
