/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/utils/operationerror', function () {

    'use strict';

    // class OperationError ===================================================

    /**
     * A special exception for document operations thrown by methods of the
     * class OperationContext.
     *
     * @constructor
     *
     * @extends Error
     *
     * @property {Object} operation
     *  The operation caused the exception.
     */
    function OperationError(message, operation) {

        this.name = 'OperationError';
        this.message = message;
        this.operation = operation;

    } // class OperationError

    // derive manually from built-in class Error
    OperationError.prototype = Object.create(Error.prototype);
    OperationError.prototype.constructor = OperationError;

    // exports ================================================================

    return OperationError;

});
