/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

/**
 * {@link LogData}
 *
 * @author <a href="mailto:malte.timmermann@open-xchange.com">Malte Timmermann</a>
 */
public class LogData {

    /**
     * Initializes a new {@link LogData}.
     * 
     * @param _key
     * @param _value
     */
    public LogData(final String _key, final String _value) {
        m_key = _key;
        m_value = _value;
    }

    /**
     * @return
     */
    public String getKey() {
        return ((null != m_key) ? m_key : "null");
    }

    /**
     * @return
     */
    public String getValue() {
        return ((null != m_value) ? m_value : "null");
    }

    // - Members ---------------------------------------------------------------

    private String m_key;

    private String m_value;

}
