/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.XTypeProvider;
import com.sun.star.lib.uno.helper.WeakAdapter;
import com.sun.star.uno.Type;
import com.sun.star.uno.XAdapter;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XWeak;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class WeakBase
implements XWeak,
XTypeProvider {
    private final boolean DEBUG = false;
    private WeakAdapter m_adapter;
    protected static Map _mapImplementationIds = new Hashtable();
    protected static Map _mapTypes = new Hashtable();

    @Override
    public synchronized XAdapter queryAdapter() {
        if (this.m_adapter == null) {
            this.m_adapter = new WeakAdapter(this);
        }
        return this.m_adapter;
    }

    protected void finalize() throws Throwable {
        if (this.m_adapter != null) {
            this.m_adapter.referentDying();
        }
        super.finalize();
    }

    @Override
    public Type[] getTypes() {
        Type[] arTypes = (Type[])_mapTypes.get(this.getClass());
        if (arTypes == null) {
            int i;
            Vector<Type> vec = new Vector<Type>();
            Class<?> currentClass = this.getClass();
            do {
                Class<?>[] interfaces = currentClass.getInterfaces();
                for (i = 0; i < interfaces.length; ++i) {
                    if (!XInterface.class.isAssignableFrom(interfaces[i])) continue;
                    vec.add(new Type(interfaces[i]));
                }
            } while ((currentClass = currentClass.getSuperclass()) != null);
            Type[] types = new Type[vec.size()];
            for (i = 0; i < types.length; ++i) {
                types[i] = (Type)vec.elementAt(i);
            }
            _mapTypes.put(this.getClass(), types);
            arTypes = types;
        }
        return arTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getImplementationId() {
        byte[] id = null;
        Map map = _mapImplementationIds;
        synchronized (map) {
            id = (byte[])_mapImplementationIds.get(this.getClass());
            if (id == null) {
                int hash = this.hashCode();
                String sName = this.getClass().getName();
                byte[] arName = sName.getBytes();
                int nNameLength = arName.length;
                id = new byte[4 + nNameLength];
                id[0] = (byte)(hash & 0xFF);
                id[1] = (byte)(hash >>> 8 & 0xFF);
                id[2] = (byte)(hash >>> 16 & 0xFF);
                id[3] = (byte)(hash >>> 24 & 0xFF);
                for (int i = 0; i < nNameLength; ++i) {
                    id[4 + i] = arName[i];
                }
                _mapImplementationIds.put(this.getClass(), id);
            }
        }
        return id;
    }
}

