/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.IllegalArgumentException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;

public class UnoUrl {
    private static final String FORMAT_ERROR = "syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname";
    private static final String VALUE_CHAR_SET = "!$&'()*+-./:?@_~";
    private static final String OID_CHAR_SET = "!$&'()*+-./:?@_~,=";
    private UnoUrlPart connection;
    private UnoUrlPart protocol;
    private String rootOid;

    private UnoUrl(UnoUrlPart connectionPart, UnoUrlPart protocolPart, String rootOid) {
        this.connection = connectionPart;
        this.protocol = protocolPart;
        this.rootOid = rootOid;
    }

    public String getConnection() {
        return this.connection.getPartTypeName();
    }

    public String getProtocol() {
        return this.protocol.getPartTypeName();
    }

    public String getRootOid() {
        return this.rootOid;
    }

    public HashMap getProtocolParameters() {
        return this.protocol.getPartParameters();
    }

    public HashMap getConnectionParameters() {
        return this.connection.getPartParameters();
    }

    public String getProtocolParametersAsString() {
        return this.protocol.getUninterpretedParameterString();
    }

    public String getConnectionParametersAsString() {
        return this.connection.getUninterpretedParameterString();
    }

    public String getProtocolAndParametersAsString() {
        return this.protocol.getUninterpretedString();
    }

    public String getConnectionAndParametersAsString() {
        return this.connection.getUninterpretedString();
    }

    private static int hexToInt(int ch) throws IllegalArgumentException {
        boolean isValidChar;
        char c = Character.toLowerCase((char)ch);
        boolean isDigit = '0' <= c && c <= '9';
        boolean bl = isValidChar = 'a' <= c && c <= 'f' || isDigit;
        if (!isValidChar) {
            throw new IllegalArgumentException("Invalid UTF-8 hex byte '" + c + "'.");
        }
        return isDigit ? ch - 48 : 10 + ((char)c - 97) & 0xF;
    }

    private static String decodeUTF8(String s) throws IllegalArgumentException {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < s.length(); ++i) {
            int ch = s.charAt(i);
            if (ch == 37) {
                int hb = UnoUrl.hexToInt(s.charAt(++i));
                int lb = UnoUrl.hexToInt(s.charAt(++i));
                ch = hb << 4 | lb;
            }
            v.addElement(new Integer(ch));
        }
        int size = v.size();
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            Integer anInt = (Integer)v.elementAt(i);
            bytes[i] = (byte)(anInt & 0xFF);
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Couldn't convert parameter string to UTF-8 string:" + e.getMessage());
        }
    }

    private static HashMap buildParamHashMap(String paramString) throws IllegalArgumentException {
        char c;
        HashMap<String, String> params = new HashMap<String, String>();
        int pos = 0;
        do {
            c = ',';
            String aKey = "";
            String aValue = "";
            while (pos < paramString.length()) {
                char c2 = paramString.charAt(pos++);
                c = c2;
                if (c2 == '=') break;
                aKey = aKey + c;
            }
            while (pos < paramString.length()) {
                char c3 = paramString.charAt(pos++);
                c = c3;
                if (c3 == ',' || c == 59) break;
                aValue = aValue + c;
            }
            if (aKey.length() <= 0 || aValue.length() <= 0) continue;
            if (!UnoUrl.isAlphaNumeric(aKey)) {
                throw new IllegalArgumentException("The parameter key '" + aKey + "' may only consist of alpha numeric ASCII characters.");
            }
            if (!UnoUrl.isValidString(aValue, "!$&'()*+-./:?@_~%")) {
                throw new IllegalArgumentException("The parameter value for key '" + aKey + "' contains illegal characters.");
            }
            params.put(aKey, UnoUrl.decodeUTF8(aValue));
        } while (pos < paramString.length() && c == 44);
        return params;
    }

    private static UnoUrlPart parseUnoUrlPart(String thePart) throws IllegalArgumentException {
        String partName = thePart;
        String theParamPart = "";
        int index = thePart.indexOf(",");
        if (index != -1) {
            partName = thePart.substring(0, index).trim();
            theParamPart = thePart.substring(index + 1).trim();
        }
        if (!UnoUrl.isAlphaNumeric(partName)) {
            throw new IllegalArgumentException("The part name '" + partName + "' may only consist of alpha numeric ASCII characters.");
        }
        HashMap params = UnoUrl.buildParamHashMap(theParamPart);
        return new UnoUrlPart(theParamPart, partName, params);
    }

    private static boolean isAlphaNumeric(String s) {
        return UnoUrl.isValidString(s, null);
    }

    private static boolean isValidString(String identifier, String validCharSet) {
        int len = identifier.length();
        for (int i = 0; i < len; ++i) {
            boolean isValidChar;
            char ch = identifier.charAt(i);
            boolean bl = isValidChar = 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9';
            if (!isValidChar && validCharSet != null) {
                boolean bl2 = isValidChar = validCharSet.indexOf(ch) != -1;
            }
            if (isValidChar) continue;
            return false;
        }
        return true;
    }

    public static UnoUrl parseUnoUrl(String unoUrl) throws IllegalArgumentException {
        String unoStr;
        String url = unoUrl;
        int index = url.indexOf(58);
        if (index != -1 && !"uno".equals(unoStr = url.substring(0, index).trim())) {
            throw new IllegalArgumentException("Uno Urls must start with 'uno:'. syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname");
        }
        if ((index = (url = url.substring(index + 1).trim()).indexOf(59)) == -1) {
            throw new IllegalArgumentException("'" + unoUrl + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        String connection = url.substring(0, index).trim();
        url = url.substring(index + 1).trim();
        UnoUrlPart connectionPart = UnoUrl.parseUnoUrlPart(connection);
        index = url.indexOf(59);
        if (index == -1) {
            throw new IllegalArgumentException("'" + unoUrl + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        String protocol = url.substring(0, index).trim();
        url = url.substring(index + 1).trim();
        UnoUrlPart protocolPart = UnoUrl.parseUnoUrlPart(protocol);
        String rootOid = url.trim();
        if (!UnoUrl.isValidString(rootOid, OID_CHAR_SET)) {
            throw new IllegalArgumentException("Root OID '" + rootOid + "' contains illegal characters.");
        }
        return new UnoUrl(connectionPart, protocolPart, rootOid);
    }

    private static class UnoUrlPart {
        private String partTypeName;
        private HashMap partParameters;
        private String uninterpretedParameterString;

        public UnoUrlPart(String uninterpretedParameterString, String partTypeName, HashMap partParameters) {
            this.uninterpretedParameterString = uninterpretedParameterString;
            this.partTypeName = partTypeName;
            this.partParameters = partParameters;
        }

        public String getPartTypeName() {
            return this.partTypeName;
        }

        public HashMap getPartParameters() {
            return this.partParameters;
        }

        public String getUninterpretedParameterString() {
            return this.uninterpretedParameterString;
        }

        public String getUninterpretedString() {
            StringBuffer buf = new StringBuffer(this.partTypeName);
            if (this.uninterpretedParameterString.length() > 0) {
                buf.append(',');
                buf.append(this.uninterpretedParameterString);
            }
            return buf.toString();
        }
    }
}

