/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust.delegation;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.ws.security.trust.delegation.DelegationCallback;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivedTokenCallbackHandler
implements CallbackHandler {
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof DelegationCallback) {
                WeakReference wr;
                SoapMessage previousSoapMessage;
                Element token;
                DelegationCallback callback = (DelegationCallback)callbacks[i];
                Message message = callback.getCurrentMessage();
                if (message == null || message.get(PhaseInterceptorChain.PREVIOUS_MESSAGE) == null || (token = this.getTokenFromMessage(previousSoapMessage = (SoapMessage)(wr = (WeakReference)message.get(PhaseInterceptorChain.PREVIOUS_MESSAGE)).get())) == null) continue;
                callback.setToken(token);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    private Element getTokenFromMessage(SoapMessage soapMessage) {
        List<WSHandlerResult> results;
        if (soapMessage != null && (results = CastUtils.cast((List)soapMessage.get("RECV_RESULTS"))) != null) {
            for (WSHandlerResult rResult : results) {
                Element token = this.findToken(rResult.getResults());
                if (token == null) continue;
                return token;
            }
        }
        return null;
    }

    private Element findToken(List<WSSecurityEngineResult> wsSecEngineResults) {
        for (WSSecurityEngineResult wser : wsSecEngineResults) {
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt == 16 || actInt == 8) {
                AssertionWrapper assertion = (AssertionWrapper)wser.get((Object)"saml-assertion");
                return assertion.getElement();
            }
            if (actInt == 1 || actInt == 8192) {
                UsernameToken token = (UsernameToken)wser.get((Object)"username-token");
                return token.getElement();
            }
            if (actInt != 4096) continue;
            BinarySecurity token = (BinarySecurity)wser.get((Object)"binary-security-token");
            return token.getElement();
        }
        return null;
    }
}

