/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.json;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.json.DataObjectFactory;

public final class LoadRawJSON {
    public static void main(String[] args) {
        try {
            File[] files;
            File[] arr$ = files = new File("statuses").listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".json");
                }
            });
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                File file = arr$[i$];
                String rawJSON = LoadRawJSON.readFirstLine(file);
                Status status = DataObjectFactory.createStatus((String)rawJSON);
                System.out.println("@" + status.getUser().getScreenName() + " - " + status.getText());
            }
            System.exit(0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("Failed to store tweets: " + ioe.getMessage());
        }
        catch (TwitterException te) {
            te.printStackTrace();
            System.out.println("Failed to get timeline: " + te.getMessage());
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFirstLine(File fileName) throws IOException {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(fileName);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            String string = br.readLine();
            return string;
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
            if (null != isr) {
                try {
                    isr.close();
                }
                catch (IOException ignore) {}
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

