/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeWorkspaceDirectoriesRequestMarshaller
implements Marshaller<Request<DescribeWorkspaceDirectoriesRequest>, DescribeWorkspaceDirectoriesRequest> {
    @Override
    public Request<DescribeWorkspaceDirectoriesRequest> marshall(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        if (describeWorkspaceDirectoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeWorkspaceDirectoriesRequest> request = new DefaultRequest<DescribeWorkspaceDirectoriesRequest>(describeWorkspaceDirectoriesRequest, "AmazonWorkspaces");
        String target = "WorkspacesService.DescribeWorkspaceDirectories";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag directoryIdsList = (ListWithAutoConstructFlag)describeWorkspaceDirectoriesRequest.getDirectoryIds();
            if (!(directoryIdsList == null || directoryIdsList.isAutoConstruct() && directoryIdsList.isEmpty())) {
                jsonWriter.key("DirectoryIds");
                jsonWriter.array();
                for (String directoryIdsListValue : directoryIdsList) {
                    if (directoryIdsListValue == null) continue;
                    jsonWriter.value(directoryIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeWorkspaceDirectoriesRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeWorkspaceDirectoriesRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

