/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractPartial
implements ReadablePartial,
Comparable {
    protected AbstractPartial() {
    }

    protected abstract DateTimeField getField(int var1, Chronology var2);

    public DateTimeFieldType getFieldType(int n) {
        return this.getField(n, this.getChronology()).getType();
    }

    public DateTimeFieldType[] getFieldTypes() {
        DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[this.size()];
        int n = 0;
        while (n < dateTimeFieldTypeArray.length) {
            dateTimeFieldTypeArray[n] = this.getFieldType(n);
            ++n;
        }
        return dateTimeFieldTypeArray;
    }

    public DateTimeField getField(int n) {
        return this.getField(n, this.getChronology());
    }

    public DateTimeField[] getFields() {
        DateTimeField[] dateTimeFieldArray = new DateTimeField[this.size()];
        int n = 0;
        while (n < dateTimeFieldArray.length) {
            dateTimeFieldArray[n] = this.getField(n);
            ++n;
        }
        return dateTimeFieldArray;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getValue(n);
            ++n;
        }
        return nArray;
    }

    public int get(DateTimeFieldType dateTimeFieldType) {
        return this.getValue(this.indexOfSupported(dateTimeFieldType));
    }

    public boolean isSupported(DateTimeFieldType dateTimeFieldType) {
        return this.indexOf(dateTimeFieldType) != -1;
    }

    public int indexOf(DateTimeFieldType dateTimeFieldType) {
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            if (this.getFieldType(n) == dateTimeFieldType) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int indexOfSupported(DateTimeFieldType dateTimeFieldType) {
        int n = this.indexOf(dateTimeFieldType);
        if (n == -1) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return n;
    }

    protected int indexOf(DurationFieldType durationFieldType) {
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            if (this.getFieldType(n).getDurationType() == durationFieldType) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int indexOfSupported(DurationFieldType durationFieldType) {
        int n = this.indexOf(durationFieldType);
        if (n == -1) {
            throw new IllegalArgumentException("Field '" + durationFieldType + "' is not supported");
        }
        return n;
    }

    public DateTime toDateTime(ReadableInstant readableInstant) {
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        long l = DateTimeUtils.getInstantMillis(readableInstant);
        long l2 = chronology.set(this, l);
        return new DateTime(l2, chronology);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReadablePartial)) {
            return false;
        }
        ReadablePartial readablePartial = (ReadablePartial)object;
        if (this.size() != readablePartial.size()) {
            return false;
        }
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            if (this.getValue(n) != readablePartial.getValue(n) || this.getFieldType(n) != readablePartial.getFieldType(n)) {
                return false;
            }
            ++n;
        }
        return FieldUtils.equals(this.getChronology(), readablePartial.getChronology());
    }

    public int hashCode() {
        int n = 157;
        int n2 = 0;
        int n3 = this.size();
        while (n2 < n3) {
            n = 23 * n + this.getValue(n2);
            n = 23 * n + this.getFieldType(n2).hashCode();
            ++n2;
        }
        return n += this.getChronology().hashCode();
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        ReadablePartial readablePartial = (ReadablePartial)object;
        if (this.size() != readablePartial.size()) {
            throw new ClassCastException("ReadablePartial objects must have matching field types");
        }
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            if (this.getFieldType(n) != readablePartial.getFieldType(n)) {
                throw new ClassCastException("ReadablePartial objects must have matching field types");
            }
            ++n;
        }
        int n3 = 0;
        int n4 = this.size();
        while (n3 < n4) {
            if (this.getValue(n3) > readablePartial.getValue(n3)) {
                return 1;
            }
            if (this.getValue(n3) < readablePartial.getValue(n3)) {
                return -1;
            }
            ++n3;
        }
        return 0;
    }

    public boolean isAfter(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(readablePartial) > 0;
    }

    public boolean isBefore(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(readablePartial) < 0;
    }

    public boolean isEqual(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(readablePartial) == 0;
    }

    public String toString(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            return this.toString();
        }
        return dateTimeFormatter.print(this);
    }

    public abstract Chronology getChronology();

    public abstract int getValue(int var1);

    public abstract int size();
}

