/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureConversationTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public SecureConversationTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SECURE_CONVERSATION_TOKEN, SP12Constants.SECURE_CONVERSATION_TOKEN};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SecureConversationToken conversationToken = new SecureConversationToken(consts);
        conversationToken.setOptional(PolicyConstants.isOptional(element));
        conversationToken.setIgnorable(PolicyConstants.isIgnorable(element));
        String attribute = DOMUtils.getAttribute(element, consts.getIncludeToken());
        if (attribute != null) {
            conversationToken.setInclusion(consts.getInclusionFromAttributeValue(attribute.trim()));
        }
        Element elem = DOMUtils.getFirstElement(element);
        boolean foundPolicy = false;
        while (elem != null) {
            QName qn = DOMUtils.getElementQName(elem);
            if (Constants.isPolicyElement((QName)qn)) {
                Element bootstrapPolicyElement;
                foundPolicy = true;
                if (DOMUtils.getFirstChildWithName(elem, consts.getNamespace(), "RequireDerivedKeys") != null) {
                    conversationToken.setDerivedKeys(true);
                } else if (DOMUtils.getFirstChildWithName(elem, SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS) != null) {
                    conversationToken.setImpliedDerivedKeys(true);
                } else if (DOMUtils.getFirstChildWithName(elem, SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS) != null) {
                    conversationToken.setExplicitDerivedKeys(true);
                }
                if (DOMUtils.getFirstChildWithName(elem, consts.getNamespace(), "RequireExternalUriReference") != null) {
                    conversationToken.setRequireExternalUriRef(true);
                }
                if (DOMUtils.getFirstChildWithName(elem, consts.getNamespace(), "SC10SecurityContextToken") != null) {
                    conversationToken.setSc10SecurityContextToken(true);
                }
                if (DOMUtils.getFirstChildWithName(elem, consts.getNamespace(), "SC13SecurityContextToken") != null) {
                    conversationToken.setSc13SecurityContextToken(true);
                }
                if ((bootstrapPolicyElement = DOMUtils.getFirstChildWithName(elem, consts.getNamespace(), "BootstrapPolicy")) != null) {
                    Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement(bootstrapPolicyElement));
                    conversationToken.setBootstrapPolicy(policy);
                }
            } else if (consts.getNamespace().equals(qn.getNamespaceURI()) && "Issuer".equals(qn.getLocalPart())) {
                conversationToken.setIssuerEpr(DOMUtils.getFirstElement(elem));
            }
            elem = DOMUtils.getNextElement(elem);
        }
        if (!foundPolicy && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:SecureConversationToken/wsp:Policy must have a value");
        }
        return conversationToken;
    }
}

