/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxb.DatatypeFactory;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.manager.SequenceTerminationPolicyType;
import org.apache.cxf.ws.rm.v200702.Expires;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

public class SourceSequence
extends AbstractSequence {
    private static final Logger LOG = LogUtils.getL7dLogger(SourceSequence.class);
    private Date expires;
    private Source source;
    private long currentMessageNumber;
    private boolean lastMessage;
    private Identifier offeringId;
    private EndpointReferenceType target;

    public SourceSequence(Identifier i, ProtocolVariation pv) {
        this(i, null, null, pv);
    }

    public SourceSequence(Identifier i, Date e, Identifier oi, ProtocolVariation pv) {
        this(i, e, oi, 0L, false, pv);
    }

    public SourceSequence(Identifier i, Date e, Identifier oi, long cmn, boolean lm, ProtocolVariation pv) {
        super(i, pv);
        this.expires = e;
        this.offeringId = oi;
        this.currentMessageNumber = cmn;
        this.lastMessage = lm;
        this.acknowledgement = new SequenceAcknowledgement();
        this.acknowledgement.setIdentifier(this.id);
    }

    public long getCurrentMessageNr() {
        return this.currentMessageNumber;
    }

    public boolean isLastMessage() {
        return this.lastMessage;
    }

    public Identifier getOfferingSequenceIdentifier() {
        return this.offeringId;
    }

    public String getEndpointIdentifier() {
        return this.source.getName().toString();
    }

    public Date getExpires() {
        return this.expires;
    }

    public boolean offeredBy(Identifier sid) {
        return null != this.offeringId && this.offeringId.getValue().equals(sid.getValue());
    }

    public boolean allAcknowledged() {
        if (!this.lastMessage) {
            return false;
        }
        if (this.acknowledgement.getAcknowledgementRange().size() == 1) {
            SequenceAcknowledgement.AcknowledgementRange r = this.acknowledgement.getAcknowledgementRange().get(0);
            return r.getLower() == 1L && r.getUpper() == this.currentMessageNumber;
        }
        return false;
    }

    public void setAcknowledged(SequenceAcknowledgement a) throws RMException {
        this.acknowledgement = a;
        this.source.getManager().getRetransmissionQueue().purgeAcknowledged(this);
        if (this.allAcknowledged()) {
            if (null == this.target || RMUtils.getAddressingConstants().getAnonymousURI().equals(this.target.getAddress().getValue())) {
                LOG.log(Level.WARNING, "STANDALONE_ANON_TERMINATE_SEQUENCE_MSG");
            } else {
                RMEndpoint rme = this.source.getReliableEndpoint();
                Proxy proxy = rme.getProxy();
                proxy.terminate(this);
                this.source.removeSequence(this);
            }
        }
    }

    public Source getSource() {
        return this.source;
    }

    void setSource(Source s) {
        this.source = s;
    }

    void setLastMessage(boolean lm) {
        this.lastMessage = lm;
    }

    boolean isExpired() {
        return this.expires == null ? false : new Date().after(this.expires);
    }

    public void setExpires(Expires ex) {
        Duration d = null;
        this.expires = null;
        if (null != ex) {
            d = ex.getValue();
        }
        if (null != d && !d.equals(DatatypeFactory.PT0S)) {
            Date now = new Date();
            this.expires = new Date(now.getTime() + ex.getValue().getTimeInMillis(now));
        }
    }

    long nextMessageNumber() {
        return this.nextMessageNumber(null, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextMessageNumber(Identifier inSeqId, long inMsgNumber, boolean last) {
        assert (!this.lastMessage);
        long result = 0L;
        SourceSequence sourceSequence = this;
        synchronized (sourceSequence) {
            ++this.currentMessageNumber;
            if (last) {
                this.lastMessage = true;
            } else {
                this.checkLastMessage(inSeqId, inMsgNumber);
            }
            result = this.currentMessageNumber;
        }
        return result;
    }

    SequenceAcknowledgement getAcknowledgement() {
        return this.acknowledgement;
    }

    synchronized void setTarget(EndpointReferenceType to) {
        if (this.target == null && !ContextUtils.isGenericAddress(to)) {
            this.target = to;
        }
    }

    synchronized EndpointReferenceType getTarget() {
        return this.target;
    }

    private void checkLastMessage(Identifier inSeqId, long inMsgNumber) {
        if (null != inSeqId && 0L != inMsgNumber) {
            Destination destination = this.source.getReliableEndpoint().getDestination();
            DestinationSequence inSeq = null;
            if (null != destination) {
                inSeq = destination.getSequence(inSeqId);
            }
            if (null != inSeq && this.offeredBy(inSeqId) && inMsgNumber == inSeq.getLastMessageNumber()) {
                this.lastMessage = true;
            }
        }
        if (!this.lastMessage) {
            SequenceTerminationPolicyType stp = this.source.getManager().getSourcePolicy().getSequenceTerminationPolicy();
            assert (null != stp);
            if (stp.getMaxLength() != 0L && stp.getMaxLength() <= this.currentMessageNumber || stp.getMaxRanges() > 0 && this.acknowledgement.getAcknowledgementRange().size() >= stp.getMaxRanges() || stp.getMaxUnacknowledged() > 0 && this.source.getManager().getRetransmissionQueue().countUnacknowledged(this) >= stp.getMaxUnacknowledged()) {
                this.lastMessage = true;
            }
        }
        if (LOG.isLoggable(Level.FINE) && this.lastMessage) {
            LOG.fine(this.currentMessageNumber + " should be the last message in this sequence.");
        }
    }
}

