/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class LocalDestination
extends AbstractDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(LocalDestination.class);
    private LocalTransportFactory localDestinationFactory;

    public LocalDestination(LocalTransportFactory localDestinationFactory, EndpointReferenceType epr, EndpointInfo ei) {
        super(epr, ei);
        this.localDestinationFactory = localDestinationFactory;
    }

    public void shutdown() {
        this.localDestinationFactory.remove(this);
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        Conduit conduit = (Conduit)inMessage.get(LocalConduit.IN_CONDUIT);
        if (conduit instanceof LocalConduit) {
            return new SynchronousConduit((LocalConduit)conduit);
        }
        return null;
    }

    class SynchronousConduit
    extends AbstractConduit {
        private LocalConduit conduit;

        public SynchronousConduit(LocalConduit conduit) {
            super(null);
            this.conduit = conduit;
        }

        public void prepare(final Message message) throws IOException {
            if (!Boolean.TRUE.equals(message.getExchange().get(LocalConduit.DIRECT_DISPATCH))) {
                final Exchange exchange = (Exchange)message.getExchange().get(LocalConduit.IN_EXCHANGE);
                AbstractWrappedOutputStream cout = new AbstractWrappedOutputStream(){

                    protected void onFirstWrite() throws IOException {
                        Executor ex;
                        PipedInputStream stream = new PipedInputStream();
                        this.wrappedStream = new PipedOutputStream(stream);
                        final MessageImpl m = new MessageImpl();
                        LocalDestination.this.localDestinationFactory.copy(message, m);
                        m.setContent(InputStream.class, stream);
                        Runnable receiver = new Runnable(){

                            public void run() {
                                if (exchange != null) {
                                    exchange.setInMessage(m);
                                }
                                SynchronousConduit.this.conduit.getMessageObserver().onMessage(m);
                            }
                        };
                        Executor executor = ex = message.getExchange() != null ? message.getExchange().get(Executor.class) : null;
                        if (ex == null || SynchronousExecutor.isA(ex)) {
                            ex = LocalDestination.this.localDestinationFactory.getExecutor();
                            if (ex != null) {
                                ex.execute(receiver);
                            } else {
                                new Thread(receiver).start();
                            }
                        } else {
                            ex.execute(receiver);
                        }
                    }
                };
                message.setContent(OutputStream.class, cout);
            } else {
                CachedOutputStream stream = new CachedOutputStream();
                message.setContent(OutputStream.class, stream);
                message.setContent(CachedOutputStream.class, stream);
                stream.holdTempFile();
            }
        }

        public void close(Message message) throws IOException {
            if (Boolean.TRUE.equals(message.getExchange().get(LocalConduit.DIRECT_DISPATCH))) {
                Exchange exchange = (Exchange)message.getExchange().get(LocalConduit.IN_EXCHANGE);
                MessageImpl copy = new MessageImpl();
                copy.putAll(message);
                message.getContent(OutputStream.class).close();
                CachedOutputStream stream = message.getContent(CachedOutputStream.class);
                message.setContent(OutputStream.class, stream);
                MessageImpl.copyContent(message, copy);
                copy.setContent(InputStream.class, stream.getInputStream());
                stream.releaseTempFileHold();
                if (exchange != null && exchange.getInMessage() == null) {
                    exchange.setInMessage(copy);
                }
                this.conduit.getMessageObserver().onMessage(copy);
                return;
            }
            super.close(message);
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

