/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelationshipJSONImpl
extends TwitterResponseImpl
implements Relationship,
Serializable {
    private static final long serialVersionUID = 7725021608907856360L;
    private final long targetUserId;
    private final String targetUserScreenName;
    private final boolean sourceBlockingTarget;
    private final boolean sourceNotificationsEnabled;
    private final boolean sourceFollowingTarget;
    private final boolean sourceFollowedByTarget;
    private final long sourceUserId;
    private final String sourceUserScreenName;

    RelationshipJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        this(res, res.asJSONObject());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, res.asJSONObject());
        }
    }

    RelationshipJSONImpl(JSONObject json) throws TwitterException {
        this(null, json);
    }

    RelationshipJSONImpl(HttpResponse res, JSONObject json) throws TwitterException {
        super(res);
        try {
            JSONObject relationship = json.getJSONObject("relationship");
            JSONObject sourceJson = relationship.getJSONObject("source");
            JSONObject targetJson = relationship.getJSONObject("target");
            this.sourceUserId = ParseUtil.getLong("id", sourceJson);
            this.targetUserId = ParseUtil.getLong("id", targetJson);
            this.sourceUserScreenName = ParseUtil.getUnescapedString("screen_name", sourceJson);
            this.targetUserScreenName = ParseUtil.getUnescapedString("screen_name", targetJson);
            this.sourceBlockingTarget = ParseUtil.getBoolean("blocking", sourceJson);
            this.sourceFollowingTarget = ParseUtil.getBoolean("following", sourceJson);
            this.sourceFollowedByTarget = ParseUtil.getBoolean("followed_by", sourceJson);
            this.sourceNotificationsEnabled = ParseUtil.getBoolean("notifications_enabled", sourceJson);
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(json.toString()).toString(), jsone);
        }
    }

    static ResponseList<Relationship> createRelationshipList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<Relationship> relationships = new ResponseListImpl<Relationship>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                RelationshipJSONImpl relationship = new RelationshipJSONImpl(json);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(relationship, json);
                }
                relationships.add(relationship);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(relationships, list);
            }
            return relationships;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    @Override
    public long getSourceUserId() {
        return this.sourceUserId;
    }

    @Override
    public long getTargetUserId() {
        return this.targetUserId;
    }

    @Override
    public boolean isSourceBlockingTarget() {
        return this.sourceBlockingTarget;
    }

    @Override
    public String getSourceUserScreenName() {
        return this.sourceUserScreenName;
    }

    @Override
    public String getTargetUserScreenName() {
        return this.targetUserScreenName;
    }

    @Override
    public boolean isSourceFollowingTarget() {
        return this.sourceFollowingTarget;
    }

    @Override
    public boolean isTargetFollowingSource() {
        return this.sourceFollowedByTarget;
    }

    @Override
    public boolean isSourceFollowedByTarget() {
        return this.sourceFollowedByTarget;
    }

    @Override
    public boolean isTargetFollowedBySource() {
        return this.sourceFollowingTarget;
    }

    @Override
    public boolean isSourceNotificationsEnabled() {
        return this.sourceNotificationsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship that = (Relationship)o;
        if (this.sourceUserId != that.getSourceUserId()) {
            return false;
        }
        if (this.targetUserId != that.getTargetUserId()) {
            return false;
        }
        if (!this.sourceUserScreenName.equals(that.getSourceUserScreenName())) {
            return false;
        }
        return this.targetUserScreenName.equals(that.getTargetUserScreenName());
    }

    public int hashCode() {
        int result = (int)(this.targetUserId ^ this.targetUserId >>> 32);
        result = 31 * result + (this.targetUserScreenName != null ? this.targetUserScreenName.hashCode() : 0);
        result = 31 * result + (this.sourceBlockingTarget ? 1 : 0);
        result = 31 * result + (this.sourceNotificationsEnabled ? 1 : 0);
        result = 31 * result + (this.sourceFollowingTarget ? 1 : 0);
        result = 31 * result + (this.sourceFollowedByTarget ? 1 : 0);
        result = 31 * result + (int)(this.sourceUserId ^ this.sourceUserId >>> 32);
        result = 31 * result + (this.sourceUserScreenName != null ? this.sourceUserScreenName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("RelationshipJSONImpl{sourceUserId=").append(this.sourceUserId).append(", targetUserId=").append(this.targetUserId).append(", sourceUserScreenName='").append(this.sourceUserScreenName).append('\'').append(", targetUserScreenName='").append(this.targetUserScreenName).append('\'').append(", sourceFollowingTarget=").append(this.sourceFollowingTarget).append(", sourceFollowedByTarget=").append(this.sourceFollowedByTarget).append(", sourceNotificationsEnabled=").append(this.sourceNotificationsEnabled).append('}').toString();
    }
}

