/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.serialization.ByteBufferObjectDataInput;
import com.hazelcast.nio.serialization.ByteBufferObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.InputOutputFactory;
import com.hazelcast.nio.serialization.SerializationService;
import java.nio.ByteOrder;

final class ByteBufferInputOutputFactory
implements InputOutputFactory {
    private final ByteOrder byteOrder;

    ByteBufferInputOutputFactory(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public BufferObjectDataInput createInput(Data data, SerializationService service) {
        return new ByteBufferObjectDataInput(data, service, this.byteOrder);
    }

    @Override
    public BufferObjectDataInput createInput(byte[] buffer, SerializationService service) {
        return new ByteBufferObjectDataInput(buffer, service, this.byteOrder);
    }

    @Override
    public BufferObjectDataOutput createOutput(int size, SerializationService service) {
        return new ByteBufferObjectDataOutput(size, service, this.byteOrder);
    }
}

