'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Plugin abstract class.
 * Every plugin should implement this interface.
 * All plugins inside cst package should extend this class.
 */
var BasePlugin = function () {
  function BasePlugin() {
    (0, _classCallCheck3.default)(this, BasePlugin);
  }

  (0, _createClass3.default)(BasePlugin, [{
    key: 'getPluginName',

    /**
     * Returns plugin name.
     * Plugin's API will be accessible using `program.plugins.<pluginName>`.
     */
    value: function getPluginName() {
      return 'basePlugin';
    }

    /**
     * Returns plugin API.
     * Plugin's API will be accessible using `program.plugins.<pluginName>`.
     */

  }, {
    key: 'createApiForProgram',
    value: function createApiForProgram(program) {}
  }]);
  return BasePlugin;
}();

exports.default = BasePlugin;
//# sourceMappingURL=BasePlugin.js.map