/**
 * plugin.js
 *
 * Copyright, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/*global tinymce:true */

tinymce.PluginManager.add('oximage', function (editor) {

    var self = this,
        cache = {};

    this.getPendingDeferreds = function (ids) {
        return _(ids)
            .chain()
            .map(function (id) {
                return cache[id];
            })
            .compact()
            .value();
    };

    /*
     * Uploads a blob image file and inserts it at the cursor position.
     */
    this.uploadBlob = function (blob) {
        var id = _.uniqueId('upload-image-'),
            windowUrl = window.URL || window.webkitURL,
            objectURL = windowUrl.createObjectURL(blob),
            img = self.addImage({ src: objectURL, id: id });

        require(['io.ox/mail/compose/inline-images', 'io.ox/core/notifications'], function (inline, notifications) {
            cache[id] = inline.api.inlineImage({ file: blob }).then(
                function success(response) {
                    var url = inline.api.getInsertedImageUrl(response),
                        ed = tinyMCE.activeEditor;

                    if (ed) {
                        var el = $(ed.getElement()),
                            currentImage;

                        if (!el) return;
                        el.trigger('beforeInlineImage', response.data[0]);
                        currentImage = $('#' + id, el).attr('src', url).removeAttr('data-pending').removeAttr('id');
                        el.trigger('addInlineImage', response.data[0]);

                        // Replace old image in the history of the undomanager
                        _(tinymce.activeEditor.undoManager.data).each(function (stage) {
                            var $content = $(stage.content);
                            $content.find('#' + id).replaceWith(currentImage.clone())
                            stage.content = $content.prop('outerHTML');
                        });

                        windowUrl.revokeObjectURL(objectURL);
                        delete cache[id];
                    }
                },
                notifications.yell
            );
        });
    };

    this.addImage = function (opt) {
        var ed = tinyMCE.activeEditor;
        if (!ed) return;
        ed.undoManager.transact(function () {
            ed.focus();
            ed.selection.setContent(ed.dom.createHTML('img', { src: opt.src, style: 'max-width: 100%;', id: opt.id, alt: '', 'data-pending': 'true' }));
        });
    }

    editor.addButton('image', {
        icon: 'image',
        title: 'Insert image',
        onPostRender: (function () {

            function change(e) {

                var file = $(this), editor = e.data.editor;

                require(['io.ox/core/notifications', 'gettext!io.ox/mail'], function (notifications, gt) {

                    if (!(/\.(gif|bmp|tiff|jpe?g|gmp|png)$/i).test(file.val())) {
                        notifications.yell('error', gt('Please select a valid image File to insert'));
                    } else {
                        if (file[0].files && tinyMCE.activeEditor) {
                            self.uploadBlob(file[0].files[0]);
                        }
                    }
                });
            }

            return function onPostRender() {
                var fileInput = $('<input type="file" name="file" capture="camera">').css('display', 'none')
                        .on('change', { editor: editor}, change);

                this.off('click');

                $('button', this.$el)
                    .on('click touchstart', function () {
                        fileInput[0].value = '';
                        fileInput.trigger('click');
                    })
                    .before(fileInput);
            };
        }())
    });

    /*
    Adds dropdown for upload and drive picker.
    This still needs some work and is deactivated for now.

    editor.addButton('image', {
        type: 'menubutton',
        icon: 'image',
        tooltip: 'Insert image',
        menu: [
            {
                text: 'Upload',
                onclick: function () {
                    require(['io.ox/mail/compose/inline-images'], function (inlineimages) {
                        inlineimages.show().done(function (url) {
                            showDialog(url);
                        });
                    });
                }
            },
            {
                text: 'Drive',
                onclick: function() {
                    // open ox filepicker
                    require(['io.ox/files/filepicker', 'io.ox/files/api', 'gettext!io.ox/files']).done(function (Picker, fileAPI, gt) {
                        var picker = new Picker({
                            primaryButtonText: gt('Add'),
                            multiselect: false,
                            filter: function (file) {
                                return (/\.(gif|bmp|tiff|jpe?g|gmp|png)$/i).test(file.filename);
                            },
                        });
                        picker.done(function (files) {
                            var url = '';
                            if (files[0]) {
                                url = fileAPI.getUrl(files[0], 'view');
                            }
                            showDialog(url);
                        });
                    });
                }
            }
        ]
    });
    */
});
