/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * 
 */

var loadPlugins, registerPlugin,
    isPluginLoaded;

(function () {
    
    var modules = null;
    
    var getModules = function () {
        
        // not first time?
        if (modules !== null) {
            return;
        }
        
        modules = ox.api.config.get("availableModules", []);
        
        // toolbar?
        if (configGetKey("ui.global.toolbar.mode.value") === "simple") {
            modules.push("com.openexchange.toolbar");
        }
        
        // turn on/off plugins via url parameter
        if (url && url.plugins !== undefined) {
            // loop over comma separated list
            var i = 0, plugins = url.plugins.split(/,/), $i = plugins.length, plugin, pos;
            for (; i < $i; i++) {
                plugin = plugins[i];
                // on/off?
                if (plugin.indexOf("-") === 0) {
                    pos = jQuery.inArray(plugin.substr(1), modules);
                    // turn off
                    if (pos > -1) {
                        modules.splice(pos, 1);
                    }
                } else {
                    pos = jQuery.inArray(plugin, modules);
                    if (pos === -1) {
                        modules.push(plugin);
                    }
                }
            }
        }
    };

    var loadCorePlugins = function (join) {
        var file = urlify("plugins/register_concat.jsz");
        jQuery.ajax({
            url: file,
            dataType: "script",
            success: join.add(),
            cache: url.dev !== "plugin"
        });
        loadCorePlugins = jQuery.noop;
    };
    
    var isCore = function (id) {
        return internalPlugins[id] !== undefined;
    };
    
    loadPlugins = function (cont) {
        
        getModules();
        
        var join = new Join(function() {
            temporary.services.finish();
            if (cont) { cont(); }
        });
        
        var lock = join.add();
        
        // loop
        var i = 0, $i = modules.length, name;
        for (; i < $i; i++) {
            name = modules[i];
            // core plugin?
            if (isCore(name) && debugPlugins === false) {
                loadCorePlugins(join);
            } else {
                // load external plugins
                loadModule(name, join);
            }
        }
        lock();
    };
    
    registerPlugin = function (id, fn) {
        // get modules
        getModules();
        // in that list?
        if (jQuery.inArray(id, modules) > -1) {
            // wrapper
            var path = oxProductInfo.build + "/plugins/" + id,
                domain = isCore(id) ? "" : id,
                gt = function (text) { return dpgettext(domain, "", text); },
                pgt = function (context, text) { return dpgettext(domain, context, text); },
                ngt = function (singular, plural, n) { return dnpgettext(domain, "", singular, plural, n); },
                npgt = function (context, singular, plural, n) { return dnpgettext(domain, context, singular, plural, n); };
            // call ("_", "gettext", "pgettext", "ngettext", "npgettext", "NAME", "PATH", "JSON")
            fn(gt, gt, pgt, ngt, npgt, id, path, JSONX);
        }
    };
    
    isPluginLoaded = function (id) {
        return loadedModules[id] === true || (url.plugins || "").indexOf(id) > -1;
    };
    
    var TRUE = function () {
        return true;
    };
    
    defineDeferredFunction = function (namespace, name, pluginId) {
        // create new function
        if (namespace && name) {
            var fn = namespace[name] = function () {
                if (fn.loading === false) {
                    fn.loading = true;
                    // get code
                    var path = "plugins/" + pluginId;
                    jQuery.ajax({
                        dataType: "text",
                        url: urlify(path + "/code.js"),
                        cache: ox.util.getHash("dev") !== "plugin"
                    }).done(function (js) {
                        loadI18n(js, pluginId, pluginId, path, function () {
                            namespace[name].available = TRUE;
                            namespace[name](); // not fn here!
                            fn = null;
                        });
                    });
                }
            };
            // init loading flag
            fn.loading = false;
            // available?
            fn.available = function () {
                // check for plugin
                return isPluginLoaded(pluginId);
            };
        }
    };
    
}());



  //////////////////////////////////////////
 //   Global names defined for plugins   //
//////////////////////////////////////////

/**
 * Translates a string.
 * @function
 * @name _
 * @param {String} text The original English text to translate.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Translates a string.
 * @function
 * @name gettext
 * @param {String} text The original English text to translate.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Translates a string with context
 * @function
 * @name pgettext
 * @param {String} context A context to differentiate multiple identical texts
 * with different translations.
 * @param {String} text The original English text to translate.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Translates a string containing numbers.
 * @function
 * @name ngettext
 * @param {String} singular The original English text for the singular form.
 * @param {String} plural The original English text for the plural form.
 * @param {Number} n The number which determines which text form is used.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Translates a string containing numbers with context.
 * @function
 * @name npgettext
 * @param {String} context A context to differentiate multiple identical texts
 * with different translations.
 * @param {String} singular The original English text for the singular form.
 * @param {String} plural The original English text for the plural form.
 * @param {Number} n The number which determines which text form is used.
 * @type I18nString
 * @return The translated text.
 */

/**
 * Converts a string to I18nString without translation.
 * @function
 * @name noI18n
 * @param {String} text The text to convert.
 * @type I18nString
 * @return The untranslated text as I18nString.
 */

//////////////////////////////////////////

/**
 * Loads a module at runtime.
 * Loading a module which is already (being) loaded has no effect. 
 * The register.js file from the module's directory is converted to the body of
 * a function and that function is called.
 * The file is downloaded asynchronously.
 * @param {String} name The name of the module to load.
 * @param {Join} join An optional Join object which is locked until the module
 * finishes loading.
 */

function loadModule(name, join, noI18n) {
    if (name in loadedModules) return;
    loadedModules[name] = true;
    if (!join) join = new Join(emptyFunction);
    // inject version
    var nocache = ox.util.getHash("dev") === "plugin" ? "?" + (new Date().getTime()) : "";
    var path = oxProductInfo.build + "/plugins/" + name;
    var url = path + "/register.js" + nocache;
    var context = internalPlugins[name] || noI18n === true ? "" : name;
    // get register.js
    (new JSONX()).get(url, null,
        join.add(function(js) {
            if (internalPlugins[name] === undefined && noI18n !== true) {
                bindtextdomain(context, "plugins/" + name + "/lang/%s.po");
            }
            loadI18n(js, context, name, path, join.add());
        }),
        join.alt(function(result, status) {
            delete loadedModules[name];
            return status == 404;
        }), true);
};

/**
 * Evaluates a JavaScript program using the specified i18n text domain.
 * The domain must have been bound using bindtextdomain().
 * The JavScript program is converted to the body of a function and
 * that function is called.
 * @param {String} js The javaScript program to evaluate.
 * @param {String} name The i18n text domain as used by bindtextdomain().
 * This value can also be accessed in the evaluated program as NAME.
 * @param {String} path The path to the file's directory.
 * This value can be accessed in the evaluated program as PATH.
 * @param {Function} cb A callback function which is called with the return
 * value of the evaluated program.
 * @return The return value of the evaluated program.
 */
function loadI18n(js, domain, name, path, cb) {
    if (debugPlugins) {
        loadI18n.params[++loadI18n.index] =
            [gt, gt, pgt, ngt, npgt, name, path, JSONX, cb];
        var src =["(function(_,gettext,pgettext,ngettext,npgettext,NAME,PATH,",
                  "JSON,$done){delete loadI18n.params[",
                  loadI18n.index, "];try{var $retval=(function(){", js,
                  "})()}finally{$done($retval);}})("];
        var params = [];
        var prefix = "loadI18n.params[" + loadI18n.index + "][";
        for (var i = 0; i < loadI18n.params[loadI18n.index].length; i++) {
            params.push(prefix + i + "]");
        }
        src.push(params.join());
        src.push(");");
        document.getElementsByTagName("head")[0].appendChild(
            newnode("script", 0, {
                type: "text/javascript",
                src: "data:text/javascript;charset=utf-8," +
                    encodeURIComponent(src.join(""))
            }));
    } else {
        cb((Function("_", "gettext", "pgettext", "ngettext", "npgettext",
            "NAME", "PATH", "JSON", js))
            (gt, gt, pgt, ngt, npgt, name, path, JSONX));
    }
    function gt(text) { return dpgettext(domain, "", text); }
    function pgt(context, text) {
        return dpgettext(domain, context, text);
    }
    function ngt(singular, plural, n) {
        return dnpgettext(domain, "", singular, plural, n);
    }
    function npgt(context, singular, plural, n) {
        return dnpgettext(domain, context, singular, plural, n);
    }
}

loadI18n.params = {};
loadI18n.index = 0;

var internalPlugins = {
    "com.openexchange.settings.folder": true,
    "com.openexchange.toolbar": true,
    "com.openexchange.group": true,
    "com.openexchange.mail.filter": true,
    "com.openexchange.oxupdater": true,
    "com.openexchange.publish": true,
    "com.openexchange.resource": true,
    "com.openexchange.secret.recovery": true,
    "com.openexchange.subscribe": true,
    "com.openexchange.user.passwordchange": true,
    "com.openexchange.user.personaldata": true,
    "com.openexchange.threadview": true,
    "com.openexchange.upsell.demo": true,
    "uwaWidgets": true
};

// TODO: fill during initialization of modules.
var loadedModules = {
    calendar: true,
    contacts: true,
    folder: true,
    infostore: true,
    interfaces: true,
    mail: true,
    mailaccount: true,
    messaging: true,
    portal: true,
    tasks: true,
    themes: true,
    folderstorage: true
};
