/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;

public final class TinyDocumentImpl
extends TinyParentNodeImpl
implements DocumentInfo {
    private HashMap idTable = null;
    private IntHashMap elementList = null;
    private HashMap entityTable = null;

    public TinyDocumentImpl(TinyTree tinyTree) {
        this.tree = tinyTree;
        this.nodeNr = tinyTree.numberOfNodes;
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public void setConfiguration(Configuration configuration) {
        if (configuration != this.tree.getConfiguration()) {
            throw new IllegalArgumentException("Configuration of document differs from that of the supporting TinyTree");
        }
    }

    public Configuration getConfiguration() {
        return this.tree.getConfiguration();
    }

    public void setSystemId(String string) {
        this.tree.setSystemId(this.nodeNr, string);
    }

    public String getSystemId() {
        return this.tree.getSystemId(this.nodeNr);
    }

    public String getBaseURI() {
        return this.getSystemId();
    }

    public int getLineNumber() {
        return 0;
    }

    public final int getNodeKind() {
        return 9;
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append('d');
        fastStringBuffer.append(Integer.toString(this.getDocumentNumber()));
    }

    AxisIterator getAllElements(int n) {
        List list;
        if (this.elementList == null) {
            this.elementList = new IntHashMap(20);
        }
        if ((list = (List)this.elementList.get(n)) == null) {
            list = this.getElementList(n);
            this.elementList.put(n, list);
        }
        return new ListIterator(list);
    }

    List getElementList(int n) {
        int n2 = this.tree.getNumberOfNodes() / 20;
        if (n2 > 100) {
            n2 = 100;
        }
        if (n2 < 20) {
            n2 = 20;
        }
        ArrayList<TinyNodeImpl> arrayList = new ArrayList<TinyNodeImpl>(n2);
        int n3 = this.nodeNr + 1;
        while (this.tree.depth[n3] != 0) {
            if (this.tree.nodeKind[n3] == 1 && (this.tree.nameCode[n3] & 0xFFFFF) == n) {
                arrayList.add(this.tree.getNode(n3));
            }
            ++n3;
        }
        return arrayList;
    }

    void registerID(NodeInfo nodeInfo, String string) {
        NodeInfo nodeInfo2;
        if (this.idTable == null) {
            this.idTable = new HashMap(256);
        }
        if ((nodeInfo2 = (NodeInfo)this.idTable.get(string)) == null) {
            this.idTable.put(string, nodeInfo);
        }
    }

    public NodeInfo selectID(String string) {
        if (this.idTable == null) {
            return null;
        }
        return (NodeInfo)this.idTable.get(string);
    }

    void setUnparsedEntity(String string, String string2, String string3) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap(20);
        }
        String[] stringArray = new String[]{string2, string3};
        this.entityTable.put(string, stringArray);
    }

    public String[] getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return null;
        }
        return (String[])this.entityTable.get(string);
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        NodeInfo nodeInfo;
        receiver.startDocument(0);
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            nodeInfo.copy(receiver, n, bl, n2);
        }
        receiver.endDocument();
    }

    public void showSize() {
        this.tree.showSize();
    }
}

