package com.openexchange.office.tools.htmldoc;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class Field
        extends SubNode
{
    private static final String BEFORECLASS = "<div contenteditable=\"false\" class=\"inline field";
    private static final String BEFORETYPE  = "\"";
    private static final String AFTERTYPE   = "><span ";
    private static final String AFTERATTRS  = " >";
    private static final String CLOSEFIELD  = "</span></div>";

    private final String        fieldText;
    private String              type;

    // ///////////////////////////////////////////////////////////

    public Field(
            int position, String representation, String type)
    {
        super(position, 1);

        this.fieldText = representation;
        this.type = type;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(BEFORECLASS);

        if (type != null)
        {
            String type = this.type;
            // System.out.println("Field.appendContent() before: '" + type + "'");

            type = type.trim().split(" ")[0];
            // System.out.println("Field.appendContent() after : '" + type + "'");

            document.append(" field-");
            document.append(StringEscapeUtils.escapeHtml(type));
        }

        if (StringUtils.isEmpty(fieldText))
        {
            if (type != null)
            {
                document.append(" ");
            }
            document.append("empty-field");
        }

        document.append(BEFORETYPE);

        JSONObject attrs = getAttribute();
        if (attrs == null)
        {
            attrs = new JSONObject();
        }

        JSONObject fieldAttrs = new JSONObject();

        if (attrs.has("field"))
        {
            fieldAttrs.put("field", attrs.remove("field"));
        }

        JSONObject jq = GenDocHelper.getJQueryData(fieldAttrs);
        if (type != null)
        {
            jq.put("type", type);
        }

        GenDocHelper.appendJQueryData(document, jq);

        document.append(AFTERTYPE);

        jq = GenDocHelper.getJQueryData(getAttribute());
        GenDocHelper.appendJQueryData(document, jq);

        document.append(AFTERATTRS);

        document.append(StringEscapeUtils.escapeHtml(fieldText));

        document.append(CLOSEFIELD);
        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public String toString()
    {
        return "Field: " + fieldText;
    }

}
