package com.openexchange.office.tools;

import java.util.Date;
import java.util.Map;
import com.openexchange.file.storage.File;

public class DocumentMetaData
{
    final public static String META_BINARY_CONVERTED = "binary_converted";

    private String lockedByUser = "";
    private Date lockedUntil = null;
    private boolean isWriteProtected = false;
    private long fileSize = 0;
    private String fileName = "";
    private final String folderId;
    private final String fileId;
    private final Date lastModified;
    private final Date created;
    private final String title;
    private final String mimeType;
    private boolean isBinaryConverted = false;

    public DocumentMetaData(final File metaData, final String lockedByUser, boolean writeProtected) {
        this.lockedByUser = lockedByUser;
        this.lockedUntil = metaData.getLockedUntil();
        this.isWriteProtected = writeProtected;
        this.fileSize = metaData.getFileSize();
        this.fileName = metaData.getFileName();
        this.folderId = metaData.getFolderId();
        this.fileId = metaData.getId();
        this.lastModified = metaData.getLastModified();
        this.created = metaData.getCreated();
        this.title = metaData.getTitle();
        this.mimeType = metaData.getFileMIMEType();

        setBinaryConverted(metaData.getMeta());
    }

    public DocumentMetaData(final StreamInfo streamInfo) {
        this.lockedByUser = streamInfo.getLockedByUser();
        this.lockedUntil = streamInfo.getMetaData().getLockedUntil();
        this.isWriteProtected = streamInfo.isWriteProtected();
        this.fileSize = streamInfo.getMetaData().getFileSize();
        this.fileName = streamInfo.getMetaData().getFileName();
        this.folderId = streamInfo.getMetaData().getFolderId();
        this.fileId = streamInfo.getMetaData().getId();
        this.lastModified = streamInfo.getMetaData().getLastModified();
        this.created = streamInfo.getMetaData().getCreated();
        this.title = streamInfo.getMetaData().getTitle();
        this.mimeType = streamInfo.getMetaData().getFileMIMEType();

        setBinaryConverted(streamInfo.getMetaData().getMeta());
    }

    /**
     * @param meta
     */
    protected void setBinaryConverted(final Map<String, Object> meta) {
        // set flag, that this document is initially created from a binary conversion
        if (null != meta) {
            final Boolean metaBinaryConverted = (Boolean) meta.get(META_BINARY_CONVERTED);

            // set flag once and instantly remove information at Map
            this.isBinaryConverted = (null != metaBinaryConverted) && metaBinaryConverted.booleanValue();
            meta.remove(META_BINARY_CONVERTED);
        }
    }

    /**
     * @return
     */
    public String getLockedByUser() {
        return lockedByUser;
    }

    /**
     * @return
     */
    public Date getLockedUntil() {
        return lockedUntil;
    }

    /**
     * @return
     */
    public boolean isWriteProtected() {
        return isWriteProtected;
    }

    /**
     * @return
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * @return
     */
    public long getFileSize() {
        return fileSize;
    }

    /**
     * @return
     */
    public String getFolderId() {
        return folderId;
    }

    /**
     * @return
     */
    public String getFileId() {
        return fileId;
    }

    /**
     * @return
     */
    public Date getLastModified() {
        return lastModified;
    }

    /**
     * @return
     */
    public Date getCreated() {
        return created;
    }

    /**
     * @return
     */
    public String getTitle() {
        return title;
    }

    /**
     * @return
     */
    public String getMimeType() {
        return mimeType;
    }

    /**
     * @return
     */
    public boolean isBinaryConverted() {
        return isBinaryConverted;
    }
}
