/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.json.actions;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;

public class CopyDocumentAction extends DocumentFilterAction {

    /**
     * {@link CopyDocumentAction}
     *
     * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
     */

    @Action(method = RequestMethod.GET, name = "copydocument", description = "Request to create a copy of the selection of a calc document for the clipboard.", parameters = {
        @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
        @Parameter(name = "id", description = "Object ID of the requested infoitem."),
        @Parameter(name = "folder_id", description = "Folder ID of the requested infoitem."),
        @Parameter(name = "initial_filename", optional=true, description = "If present the new filename of the requested filestore item to be set."),
        @Parameter(name = "asTemplate", optional=true, description = "If present specifies that the file should be stored as template."),
        @Parameter(name = "outFolder_id", optional=true, description = "If present the folder ID where to write the requested infoitem, otherwise the folder of the source is used or if not possible the"),
        @Parameter(name = "uid", description = "The unique id of the client application.")
    }, responseDescription = "Response with timestamp: A JSON object containing the new data of the copied file or error information.")

    /**
     * Initializes a new {@link CopyDocumentAction}.
     * @param services
     */
    public CopyDocumentAction(ServiceLookup services) {
        super(services);
    }

    /* (non-Javadoc)
     * @see com.openexchange.ajax.requesthandler.AJAXActionService#perform(com.openexchange.ajax.requesthandler.AJAXRequestData, com.openexchange.tools.session.ServerSession)
     */
    @Override
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        final JSONObject requestData = new JSONObject();

        try {
            requestData.put("fileName", request.getParameter("initial_filename"));
            requestData.put("asTemplate", request.getParameter("asTemplate"));
            requestData.put("targetFolder", request.getParameter("outFolder_id"));
        } catch (JSONException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }

        return getAjaxRequestResult(sendConnectionMessageSynchronously(request, session, "copyDocument", "document", requestData));
    }
}
