/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.configuration.configitems.cluster_management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

//=============================================================================
public class AppDescriptor implements Serializable
{
	//-------------------------------------------------------------------------
	private static final long serialVersionUID = 1L;

	//-------------------------------------------------------------------------
	public static final int INVALID_PORT = -1;
	
	//-------------------------------------------------------------------------
	public static final String CFGKEY_ID                = "id"                  ;
	public static final String CFGKEY_EXE               = "executable.exe"      ;
	public static final String CFGKEY_EXE_TYPE          = "executable.type"     ;
	public static final String CFGKEY_EXE_ARGS          = "executable.arguments";
	public static final String CFGKEY_MIN_INSTANCES     = "min-instances"       ;
	public static final String CFGKEY_MAX_INSTANCES     = "max-instances"       ;
	public static final String CFGKEY_RUNLEVEL          = "run-level"           ;
	public static final String CFGKEY_START_MODE        = "start-mode"          ;
	public static final String CFGKEY_CLUSTERENV_AWARE  = "cluster-env-aware"   ;
	public static final String CFGKEY_JOLOKIA_PORT      = "jolokia.port"        ;
	public static final String CFGKEY_JMX_PORT          = "jmx.port"            ;
	
	//-------------------------------------------------------------------------
	public AppDescriptor ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	@Override
	public String toString ()
	{
		try
		{
			final StringBuffer sString = new StringBuffer (256);
			
			sString.append (super.toString ()     );
			sString.append (" {"                  );
			sString.append ("id="                 );
			sString.append (m_sId                 );
			sString.append (", type="             );
			sString.append (m_eType               );
			sString.append (", executable="       );
			sString.append (m_sExecutable         );
			sString.append (", start-mode="       );
			sString.append (m_eStartMode          );
			sString.append (", cluster-env-aware=");
			sString.append (m_bClusterEnvAware    );
			sString.append (", arguments="        );
			sString.append (mem_Arguments()       );
			sString.append (", max-instances="    );
			sString.append (m_nMaxInstances       );
			sString.append (", runlevel="         );
			sString.append (m_nRunLevel           );
			sString.append (", jolokia-port-min=" );
			sString.append (m_nJolokiaPortRangeMin);
			sString.append (", jolokia-port-max=" );
			sString.append (m_nJolokiaPortRangeMax);
			sString.append (", jmx-port="         );
			sString.append (m_nJmxPort            );
			sString.append ("}"                   );
			
			return sString.toString ();
		}
		catch (Exception ex)
		{
			return super.toString ();
		}
	}
	
	//-------------------------------------------------------------------------
	public void setId (final String sId)
		throws Exception
	{
		m_sId = sId;
	}
	
	//-------------------------------------------------------------------------
	public void setType (final String sType)
		throws Exception
	{
		m_eType = EAppType.fromString(sType);
	}

	//-------------------------------------------------------------------------
	public void setExecutable (final String sExe)
		throws Exception
	{
		m_sExecutable = sExe;
	}

	//-------------------------------------------------------------------------
	public void setStartMode (final String sMode)
		throws Exception
	{
		m_eStartMode = EStartMode.fromString(sMode);
	}

	//-------------------------------------------------------------------------
	public void setClusterEnvAware (final boolean bAware)
		throws Exception
	{
		m_bClusterEnvAware = bAware;
	}

	//-------------------------------------------------------------------------
	public void addArgument (final String sArg)
		throws Exception
	{
		mem_Arguments ().add(sArg);
	}

	//-------------------------------------------------------------------------
	public void setMinInstances (final int nInstances)
	    throws Exception
	{
		m_nMinInstances = nInstances;
	}

	//-------------------------------------------------------------------------
	public void setMaxInstances (final int nInstances)
	    throws Exception
	{
		m_nMaxInstances = nInstances;
	}

	//-------------------------------------------------------------------------
	public void setRunLevel (final int nRunLevel)
	    throws Exception
	{
		m_nRunLevel = nRunLevel;
	}

	//-------------------------------------------------------------------------
	public void setJolokiaPortRangeMin (final int nPort)
	    throws Exception
	{
		m_nJolokiaPortRangeMin = nPort;
	}
	
	//-------------------------------------------------------------------------
	public void setJolokiaPortRangeMax (final int nPort)
	    throws Exception
	{
		m_nJolokiaPortRangeMax = nPort;
	}

	//-------------------------------------------------------------------------
	public void setJmxPort (final int nJmxPort)
	    throws Exception
	{
		m_nJmxPort = nJmxPort;
	}

	//-------------------------------------------------------------------------
	public String getId ()
	    throws Exception
	{
		return m_sId;
	}
	
	//-------------------------------------------------------------------------
	public EAppType getType ()
	    throws Exception
	{
		return m_eType;
	}

	//-------------------------------------------------------------------------
	public String getExecutable ()
	    throws Exception
	{
		return m_sExecutable;
	}

	//-------------------------------------------------------------------------
	public EStartMode getStartMode ()
	    throws Exception
	{
		return m_eStartMode;
	}

	//-------------------------------------------------------------------------
	public boolean isClusterEnvAware ()
		throws Exception
	{
		return m_bClusterEnvAware;
	}

	//-------------------------------------------------------------------------
	public List< String > getArguments ()
	    throws Exception
	{
		return mem_Arguments ();
	}

	//-------------------------------------------------------------------------
	public int getMaxInstances ()
	    throws Exception
	{
		return m_nMaxInstances;
	}
	
	//-------------------------------------------------------------------------
	public int getMinInstances ()
	    throws Exception
	{
		return m_nMinInstances;
	}

	//-------------------------------------------------------------------------
	public int getRunLevel ()
	    throws Exception
	{
		return m_nRunLevel;
	}

	//-------------------------------------------------------------------------
	public boolean isJolokiaEnabled ()
		throws Exception
	{
		if (
			(m_nJolokiaPortRangeMin != INVALID_PORT          ) &&
			(m_nJolokiaPortRangeMax != INVALID_PORT          ) &&
			(m_nJolokiaPortRangeMin <= m_nJolokiaPortRangeMax)
		   )
			return true;
		
		return false;
	}

	//-------------------------------------------------------------------------
	public int getJolokiaPortRangeMin ()
	    throws Exception
	{
		return m_nJolokiaPortRangeMin;
	}

	//-------------------------------------------------------------------------
	public int getJolokiaPortRangeMax ()
	    throws Exception
	{
		return m_nJolokiaPortRangeMax;
	}

	//-------------------------------------------------------------------------
	public boolean isJmxEnabled ()
		throws Exception
	{
		return (m_nJmxPort != INVALID_PORT);
	}
	
	//-------------------------------------------------------------------------
	public int getJmxPort ()
	    throws Exception
	{
		return m_nJmxPort;
	}

	//-------------------------------------------------------------------------
	private List< String > mem_Arguments ()
	    throws Exception
	{
		if (m_lArguments == null)
			m_lArguments = new ArrayList< String > ();
		return m_lArguments;
	}
	
	//-------------------------------------------------------------------------
	private String m_sId = null;

	//-------------------------------------------------------------------------
	private EAppType m_eType = null;

	//-------------------------------------------------------------------------
	private String m_sExecutable = null;

	//-------------------------------------------------------------------------
	private EStartMode m_eStartMode = null;

	//-------------------------------------------------------------------------
	private boolean m_bClusterEnvAware = false;

	//-------------------------------------------------------------------------
	private List< String > m_lArguments = null;

	//-------------------------------------------------------------------------
	private int m_nMinInstances = 0;
	
	//-------------------------------------------------------------------------
	private int m_nMaxInstances = 0;

	//-------------------------------------------------------------------------
	private int m_nRunLevel = 0;

	//-------------------------------------------------------------------------
	private int m_nJolokiaPortRangeMin = INVALID_PORT;
	
	//-------------------------------------------------------------------------
	private int m_nJolokiaPortRangeMax = INVALID_PORT;

	//-------------------------------------------------------------------------
	private int m_nJmxPort = INVALID_PORT;
}
