/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.configuration;

import org.apache.commons.lang3.StringUtils;

import sun.net.www.protocol.classpath.ClasspathConnection;

import com.openxchange.office_communication.tools.config.ConfigurationFactory;
import com.openxchange.office_communication.tools.config.IComplexConfiguration;

//=============================================================================
public class ConfigAccess
{
	//-------------------------------------------------------------------------
	private ConfigAccess ()
		throws Exception
	{}

	//-------------------------------------------------------------------------
	public static IComplexConfiguration accessConfig (final String sConfig)
	    throws Exception
	{
		final ConfigAccess          aAccess     = mem_Singleton ();
		final String                sConfigRoot = aAccess.mem_ConfigRoot ();
		final IComplexConfiguration iConfig     = ConfigurationFactory.getComplexConfiguration(sConfigRoot, sConfig);
		return iConfig;
	}

	//-------------------------------------------------------------------------
	private static ConfigAccess mem_Singleton ()
	    throws Exception
	{
		if (m_gSingleton == null)
			m_gSingleton = new ConfigAccess ();
		return m_gSingleton;
	}

	//-------------------------------------------------------------------------
	private String mem_ConfigRoot ()
	    throws Exception
	{
		if (m_sConfigRoot == null)
		{
			String sRoot  = ConfigAccess.class.getName ();
			       sRoot  = StringUtils.substringBeforeLast(sRoot, ".");
			       sRoot  = StringUtils.replace(sRoot, ".", "/");
			       sRoot  = StringUtils.removeEnd(sRoot, "/");
			       sRoot  = ClasspathConnection.PROTOCOL + ":/" + sRoot;
			m_sConfigRoot = sRoot;
		}
		return m_sConfigRoot;
	}

	//-------------------------------------------------------------------------
	private static ConfigAccess m_gSingleton = null;

	//-------------------------------------------------------------------------
	private String m_sConfigRoot = null;
}
