/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.jms.core.plain;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.jms.Message;

import org.apache.commons.lang3.Validate;

//=============================================================================
public class JMSRequestResponseManager
{
	//-------------------------------------------------------------------------
	public JMSRequestResponseManager ()
	{}

	//-------------------------------------------------------------------------
	public static void bindResponseToRequest (final Message aResponse,
										      final Message aRequest )
	    throws Exception
	{
		final String sCorrelationID = aRequest.getJMSCorrelationID();
		Validate.notEmpty(sCorrelationID, "No correlation ID foun on request. Can not bind response to it !");
		aResponse.setJMSCorrelationID(sCorrelationID);
	}

	//-------------------------------------------------------------------------
	public JMSRequestResponsePair registerRequest (final Message aRequest)
	    throws Exception
	{
		final String sCorrelationID = impl_newCorrelationID ();
		aRequest.setJMSCorrelationID(sCorrelationID);
		
		final Map< String, JMSRequestResponsePair > aRegistry      = mem_Registry ();
		final JMSRequestResponsePair                aReqistryEntry = new JMSRequestResponsePair ();

		aReqistryEntry.setRequest(aRequest);
		
		synchronized(aRegistry)
		{
			aRegistry.put(sCorrelationID, aReqistryEntry);
		}
		
		return aReqistryEntry;
	}
	
	//-------------------------------------------------------------------------
	public JMSRequestResponsePair registerResponseAndNotify (final Message aResponse)
	    throws Exception
	{
		final String sID = aResponse.getJMSCorrelationID();
		Validate.notEmpty(sID, "Miss correlation ID for this response !");

		final Map< String, JMSRequestResponsePair > aRegistry      = mem_Registry ();
			  JMSRequestResponsePair                aRegistryEntry = null;

		synchronized(aRegistry)
		{
			aRegistryEntry = aRegistry.get(sID);
			aRegistry.remove(sID);
		}
		
		if (aRegistryEntry == null)
		{
			// TODO error handling
			throw new RuntimeException ("Miss registry item to bind response to request ... and dont know how to handle these error ,-)");
		}

		aRegistryEntry.notifyResponse (aResponse);
		
		return aRegistryEntry;
	}

	//-------------------------------------------------------------------------
	private String impl_newCorrelationID ()
	    throws Exception
	{
		return UUID.randomUUID().toString();
	}
	
	//-------------------------------------------------------------------------
	private synchronized Map< String, JMSRequestResponsePair > mem_Registry ()
		throws Exception
	{
		if (m_aRegistry == null)
			m_aRegistry = new HashMap< String, JMSRequestResponsePair > ();
		return m_aRegistry;
	}
	
	//-------------------------------------------------------------------------
	private Map< String, JMSRequestResponsePair > m_aRegistry = null;
}