/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.hyphenation.HyphenationTreeCache;
import org.apache.fop.util.LogUtil;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.xml.sax.SAXException;

public class FopFactoryConfigurator {
    public static final boolean DEFAULT_BREAK_INDENT_INHERITANCE = false;
    public static final boolean DEFAULT_STRICT_USERCONFIG_VALIDATION = true;
    public static final boolean DEFAULT_STRICT_FO_VALIDATION = true;
    public static final String DEFAULT_PAGE_WIDTH = "8.26in";
    public static final String DEFAULT_PAGE_HEIGHT = "11in";
    public static final float DEFAULT_SOURCE_RESOLUTION = 72.0f;
    public static final float DEFAULT_TARGET_RESOLUTION = 72.0f;
    public static final boolean DEFAULT_COMPLEX_SCRIPT_FEATURES = true;
    private static final String PREFER_RENDERER = "prefer-renderer";
    private final Log log = LogFactory.getLog(FopFactoryConfigurator.class);
    private FopFactory factory = null;
    private Configuration cfg = null;
    private URI baseURI = null;

    public FopFactoryConfigurator(FopFactory factory) {
        this.factory = factory;
    }

    public void configure(FopFactory factory) throws FOPException {
        Configuration csConfig;
        Configuration pageConfig;
        Configuration[] hyphPatConfig;
        String path;
        if (this.cfg.getChild("strict-configuration", false) != null) {
            try {
                factory.setStrictUserConfigValidation(this.cfg.getChild("strict-configuration").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, (Exception)((Object)e), false);
            }
        }
        boolean strict = factory.validateUserConfigStrictly();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing FopFactory Configurationwith " + (strict ? "strict" : "permissive") + " validation"));
        }
        if (this.cfg.getChild("accessibility", false) != null) {
            try {
                this.factory.setAccessibility(this.cfg.getChild("accessibility").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, (Exception)((Object)e), strict);
            }
        }
        if (this.cfg.getChild("strict-validation", false) != null) {
            try {
                factory.setStrictValidation(this.cfg.getChild("strict-validation").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, (Exception)((Object)e), strict);
            }
        }
        if (this.cfg.getChild("base", false) != null) {
            path = this.cfg.getChild("base").getValue(null);
            if (this.baseURI != null) {
                path = this.baseURI.resolve(path).normalize().toString();
            }
            try {
                factory.setBaseURL(path);
            }
            catch (MalformedURLException mfue) {
                LogUtil.handleException(this.log, mfue, strict);
            }
        }
        if (this.cfg.getChild("hyphenation-base", false) != null) {
            path = this.cfg.getChild("hyphenation-base").getValue(null);
            if (this.baseURI != null) {
                path = this.baseURI.resolve(path).normalize().toString();
            }
            try {
                factory.setHyphenBaseURL(path);
            }
            catch (MalformedURLException mfue) {
                LogUtil.handleException(this.log, mfue, strict);
            }
        }
        if ((hyphPatConfig = this.cfg.getChildren("hyphenation-pattern")).length != 0) {
            HashMap<String, String> hyphPatNames = new HashMap<String, String>();
            for (int i = 0; i < hyphPatConfig.length; ++i) {
                String filename;
                StringBuffer error = new StringBuffer();
                String location = hyphPatConfig[i].getLocation();
                String lang = hyphPatConfig[i].getAttribute("lang", null);
                if (lang == null) {
                    FopFactoryConfigurator.addError("The lang attribute of a hyphenation-pattern configuration element must exist (" + location + ")", error);
                } else if (!lang.matches("[a-zA-Z]{2}")) {
                    FopFactoryConfigurator.addError("The lang attribute of a hyphenation-pattern configuration element must consist of exactly two letters (" + location + ")", error);
                }
                lang = lang.toLowerCase();
                String country = hyphPatConfig[i].getAttribute("country", null);
                if ("".equals(country)) {
                    country = null;
                }
                if (country != null) {
                    if (!country.matches("[a-zA-Z]{2}")) {
                        FopFactoryConfigurator.addError("The country attribute of a hyphenation-pattern configuration element must consist of exactly two letters (" + location + ")", error);
                    }
                    country = country.toUpperCase();
                }
                if ((filename = hyphPatConfig[i].getValue(null)) == null) {
                    FopFactoryConfigurator.addError("The value of a hyphenation-pattern configuration element may not be empty (" + location + ")", error);
                }
                if (error.length() != 0) {
                    LogUtil.handleError(this.log, error.toString(), strict);
                    continue;
                }
                String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
                hyphPatNames.put(llccKey, filename);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Using hyphenation pattern filename " + filename + " for lang=\"" + lang + "\"" + (country != null ? ", country=\"" + country + "\"" : "")));
            }
            factory.setHyphPatNames(hyphPatNames);
        }
        if (this.cfg.getChild("source-resolution", false) != null) {
            factory.setSourceResolution(this.cfg.getChild("source-resolution").getValueAsFloat(72.0f));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("source-resolution set to: " + factory.getSourceResolution() + "dpi (px2mm=" + factory.getSourcePixelUnitToMillimeter() + ")"));
            }
        }
        if (this.cfg.getChild("target-resolution", false) != null) {
            factory.setTargetResolution(this.cfg.getChild("target-resolution").getValueAsFloat(72.0f));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("target-resolution set to: " + factory.getTargetResolution() + "dpi (px2mm=" + factory.getTargetPixelUnitToMillimeter() + ")"));
            }
        }
        if (this.cfg.getChild("break-indent-inheritance", false) != null) {
            try {
                factory.setBreakIndentInheritanceOnReferenceAreaBoundary(this.cfg.getChild("break-indent-inheritance").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, (Exception)((Object)e), strict);
            }
        }
        if ((pageConfig = this.cfg.getChild("default-page-settings")).getAttribute("height", null) != null) {
            factory.setPageHeight(pageConfig.getAttribute("height", DEFAULT_PAGE_HEIGHT));
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Default page-height set to: " + factory.getPageHeight()));
            }
        }
        if (pageConfig.getAttribute("width", null) != null) {
            factory.setPageWidth(pageConfig.getAttribute("width", DEFAULT_PAGE_WIDTH));
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Default page-width set to: " + factory.getPageWidth()));
            }
        }
        if (this.cfg.getChild(PREFER_RENDERER, false) != null) {
            try {
                factory.getRendererFactory().setRendererPreferred(this.cfg.getChild(PREFER_RENDERER).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, (Exception)((Object)e), strict);
            }
        }
        if ((csConfig = this.cfg.getChild("complex-scripts")) != null) {
            this.factory.setComplexScriptFeaturesEnabled(!csConfig.getAttributeAsBoolean("disabled", false));
        }
        new FontManagerConfigurator(this.cfg, this.baseURI).configure(factory.getFontManager(), strict);
        this.configureImageLoading(this.cfg.getChild("image-loading", false), strict);
    }

    private static void addError(String message, StringBuffer error) {
        if (error.length() != 0) {
            error.append(". ");
        }
        error.append(message);
    }

    private void configureImageLoading(Configuration parent, boolean strict) throws FOPException {
        if (parent == null) {
            return;
        }
        ImageImplRegistry registry = this.factory.getImageManager().getRegistry();
        Configuration[] penalties = parent.getChildren("penalty");
        try {
            for (Configuration penaltyCfg : penalties) {
                String className = penaltyCfg.getAttribute("class");
                String value = penaltyCfg.getAttribute("value");
                Penalty p = null;
                if (value.toUpperCase().startsWith("INF")) {
                    p = Penalty.INFINITE_PENALTY;
                } else {
                    try {
                        p = Penalty.toPenalty((int)Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LogUtil.handleException(this.log, nfe, strict);
                    }
                }
                if (p == null) continue;
                registry.setAdditionalPenalty(className, p);
            }
        }
        catch (ConfigurationException e) {
            LogUtil.handleException(this.log, (Exception)((Object)e), strict);
        }
    }

    public void setUserConfig(File userConfigFile) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.buildFromFile(userConfigFile));
        }
        catch (ConfigurationException e) {
            throw new FOPException((Exception)((Object)e));
        }
    }

    public void setUserConfig(String uri) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.build(uri));
        }
        catch (ConfigurationException e) {
            throw new FOPException((Exception)((Object)e));
        }
    }

    public void setUserConfig(Configuration cfg) throws FOPException {
        this.cfg = cfg;
        this.setBaseURI();
        this.configure(this.factory);
    }

    public Configuration getUserConfig() {
        return this.cfg;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    private void setBaseURI() throws FOPException {
        String loc = this.cfg.getLocation();
        try {
            if (loc != null && loc.startsWith("file:")) {
                this.baseURI = new URI(loc);
                this.baseURI = this.baseURI.resolve(".").normalize();
            }
            if (this.baseURI == null) {
                this.baseURI = new File(System.getProperty("user.dir")).toURI();
            }
        }
        catch (URISyntaxException e) {
            throw new FOPException(e);
        }
    }
}

