package com.openexchange.office.tools.htmldoc;

import org.json.JSONObject;

public class HeaderFooter
        extends NodeHolder
{

    private final String type;
    private final String id;

    public HeaderFooter(
            String id, String type)
    {
        this.type = type;
        this.id = id;

    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {

        document.append("<div class='inactive-selection " + type.split("_")[0] + " " + id + " " + type + "'");

        JSONObject params = new JSONObject();
        params.put("id", id);
        params.put("type", type);

        document.append(" jquerydata='");
        document.append(params.toString());
        document.append("' ");

        document.append(">");

        super.appendContent(document);

        document.append("</div>");

        return true;
    }

}
