/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.worker;

import org.apache.commons.lang.Validate;

import com.openexchange.office.tools.commandline.CommandLineBase;

//==============================================================================
public class WorkerCommandLine extends CommandLineBase
{
    //--------------------------------------------------------------------------
	public static final String OPT_SHORT_PORT = "p";
	public static final String OPT_LONG_PORT  = "port";
	
    //--------------------------------------------------------------------------
	public static final String OPT_SHORT_INTERFACE = "i";
	public static final String OPT_LONG_INTERFACE  = "interface";
	
    //--------------------------------------------------------------------------
	public static final String OPT_SHORT_SIMULATE = "s";
	public static final String OPT_LONG_SIMULATE  = "simulate";

    //--------------------------------------------------------------------------
	public static final String OPT_SHORT_DEBUG = "d";
	public static final String OPT_LONG_DEBUG  = "debug";

    //--------------------------------------------------------------------------
	public static final String OPT_SHORT_MEMORY = "m";
	public static final String OPT_LONG_MEMORY  = "memory";

	//--------------------------------------------------------------------------
	public WorkerCommandLine()
		throws Exception
	{
		super("calc-engine-worker");
		
        addOption (OPT_SHORT_PORT    		            ,
        		   OPT_LONG_PORT                        ,
                   CommandLineBase.HAS_VALUE            ,
                   CommandLineBase.REQUIRED             ,
                   "port used for incoming connections.");

        addOption (OPT_SHORT_INTERFACE    		        ,
        		   OPT_LONG_INTERFACE                   ,
                   CommandLineBase.HAS_VALUE            ,
                   CommandLineBase.NOT_REQUIRED         ,
                   "network interface used for incoming connections."    +
                   "Default is 0.0.0.0 for local and remote connections.");

        addOption (OPT_SHORT_SIMULATE    		          ,
        		   OPT_LONG_SIMULATE                      ,
                   CommandLineBase.HAS_NO_VALUE           ,
                   CommandLineBase.NOT_REQUIRED           ,
                   "enable special simulation mode."      +
                   "In those mode no C++ code is called!" +
                   "All operation will be simulated."     +
                   "Not thought for real production mode.");

        addOption (OPT_SHORT_DEBUG    		                   ,
        		   OPT_LONG_DEBUG                              ,
                   CommandLineBase.HAS_NO_VALUE                ,
                   CommandLineBase.NOT_REQUIRED                ,
                   "enable special debug mode."                +
                   "In those mode debug information will "     +
                   "logged. E.g. Http request/response "       +
                   "pairs will be printed out in it's details.");

        // note : this argument is not used within the JAR ...
        // it's used within outside shell script to define
        // the ulimit. But in case it's passed to the JAR
        // directly we need to understand (and ignore) it.
        
        addOption (OPT_SHORT_MEMORY    		              ,
        		   OPT_LONG_MEMORY                        ,
                   CommandLineBase.HAS_VALUE              ,
                   CommandLineBase.NOT_REQUIRED           ,
                   "define memory for this process."      +
                   "It's not supported within the JAR ...");
	}

	//--------------------------------------------------------------------------
    @Override
	protected void verifyInt()
		throws Exception
	{
    	int nPort = getPort ();
    	Validate.isTrue(nPort > 0, "Port has to be > 0.");
	}

	//--------------------------------------------------------------------------
	public int getPort ()
	    throws Exception
	{
		final String sPort = getOptionValue(OPT_SHORT_PORT);
		final int    nPort = Integer.parseInt(sPort);
		return nPort;
	}

	//--------------------------------------------------------------------------
	public String getInterface ()
	    throws Exception
	{
		final String sInterface = getOptionValue(OPT_SHORT_INTERFACE);
		return sInterface;
	}

	//--------------------------------------------------------------------------
	public boolean isSimulationOn ()
	    throws Exception
	{
		final boolean bIsSimulationOn = hasOption(OPT_SHORT_SIMULATE);
		return bIsSimulationOn;
	}

	//--------------------------------------------------------------------------
	public boolean isDebugOn ()
	    throws Exception
	{
		final boolean bIsDebugOn = hasOption(OPT_SHORT_DEBUG);
		return bIsDebugOn;
	}
}
