/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.persistence.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionOptions.TransactionType;
import com.openxchange.office_communication.configuration.configitems.CacheServerConfig;
import com.openxchange.office_communication.tools.persistence.ISimplePersistenceTransacted;

//=============================================================================
public class HazelcastPersistence implements ISimplePersistenceTransacted
{
	//-------------------------------------------------------------------------
	public HazelcastPersistence ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	public void setScope (final String sScope)
	    throws Exception
	{
		m_sScope = sScope;

		// TRICKY and DIRTY
		// HZ will join the cluster in case an HazelcastInstance exists only (of course).
		// So this line ensure this persistence instance will join the cluster and
		// distributed data of other processes reach our own process ;-)
		// TODO think about : do we need an explicit start/stop API ?
		mem_Core ();
	}

	//-------------------------------------------------------------------------
	public synchronized List< String > listKeys ()
		throws Exception
	{
		final HazelcastInstance      aCore  = mem_Core ();
		final IMap< Object, Object > aStore = aCore.getMap(m_sScope);
		final Iterator< Object >     rKeys  = aStore.keySet().iterator();
		final List< String >         lKeys  = new Vector< String > ();
		
		while (rKeys.hasNext())
		{
			final Object aKey = rKeys.next();
			
			if (aKey instanceof String)
				lKeys.add ((String)aKey);
			else
				throw new UnsupportedOperationException ("Key '"+aKey+"' is not a string.");
		}

		return lKeys;
	}

	//-------------------------------------------------------------------------
	@Override
	public synchronized < T extends Serializable > void set (final String sKey  ,
			                                                 final T      aValue)
	    throws Exception
	{
		final HazelcastInstance      aCore  = mem_Core ();
		final IMap< Object, Object > aStore = aCore.getMap(m_sScope);
		
		if (aValue == null)
			aStore.remove(sKey);
		else
			aStore.put(sKey, aValue);
	}

	//-------------------------------------------------------------------------
	@Override
	@SuppressWarnings("unchecked")
	public synchronized < T extends Serializable > T get (final String sKey)
	    throws Exception
	{
		final HazelcastInstance      aCore  = mem_Core ();
		final IMap< Object, Object > aStore = aCore.getMap(m_sScope);
		      Object                 aValue = null;
		
		if (aStore.containsKey(sKey))
			aValue = aStore.get(sKey);
		
		return (T) aValue;
	}
	
	//-------------------------------------------------------------------------
	@Override
	public synchronized void begin ()
		throws Exception
	{
		// a) transaction already started
		
		if (m_aTransaction != null)
			return;

		// b) start new transaction

		final HazelcastInstance  aCore        = mem_Core ();
		final TransactionOptions aOption      = new TransactionOptions()
	                      							.setTransactionType(TransactionType.LOCAL);
		final TransactionContext aTransaction = aCore.newTransactionContext(aOption);

		aTransaction.beginTransaction();
		m_aTransaction = aTransaction;
	}

	//-------------------------------------------------------------------------
	@Override
	public synchronized void commit ()
		throws Exception
	{
		// a) no transaction running
		
		if (m_aTransaction == null)
			return;

		// b) finish transaction
		
		m_aTransaction.commitTransaction();
		m_aTransaction = null;
	}

	//-------------------------------------------------------------------------
	@Override
	public synchronized void rollback ()
		throws Exception
	{
		// a) no transaction running
		
		if (m_aTransaction == null)
			return;

		// b) finish transaction
		
		m_aTransaction.rollbackTransaction();
		m_aTransaction = null;
	}

	//-------------------------------------------------------------------------
	private HazelcastInstance mem_Core ()
	    throws Exception
	{
		if (m_aCore == null)
		{
//		    {
//		      //final Config       aConfig = impl_configClusterMember4Localhost ();
//			    final Config       aConfig = impl_configClusterMember4Multicast ();
//		    	                   m_aCore = Hazelcast.newHazelcastInstance(aConfig);
//		    }

		    {
		    	final ClientConfig aConfig = impl_configClientStatic ();
		    	                   m_aCore = HazelcastClient.newHazelcastClient(aConfig);
		    }
		}
		return m_aCore;
	}

	//-------------------------------------------------------------------------
	private ClientConfig impl_configClientStatic ()
		throws Exception
	{
		final ClientConfig aConfig = new ClientConfig ();

		aConfig.setProperty("hazelcast.jmx.detailed"                 , "false");
		aConfig.setProperty("hazelcast.jmx"                          , "false");
		aConfig.setProperty("hazelcast.prefer.ipv4.stack"            , "true" );
		aConfig.setProperty("hazelcast.executor.client.thread.count" , "20"   );
		aConfig.setProperty("hazelcast.version.check.enabled"        , "false");
		aConfig.setProperty("hazelcast.logging.type"                 , "slf4j");
		aConfig.setProperty(GroupProperties.PROP_SHUTDOWNHOOK_ENABLED, "false");

		final ClientNetworkConfig aNetwork        = aConfig.getNetworkConfig ();
		final GroupConfig         aGroup          = aConfig.getGroupConfig   ();
		final CacheServerConfig   aCfg            = CacheServerConfig.access ();
		final String              sServerHost     = aCfg.getHost();
		final int                 nServerPort     = aCfg.getPort();
		final String              sServerAddress  = sServerHost + ":" + nServerPort;
		final String              sServerId       = aCfg.getId();
		final String              sServerPassword = aCfg.getPassword();
		
		aNetwork.addAddress (sServerAddress );
		aGroup  .setName    (sServerId      );
		aGroup  .setPassword(sServerPassword);

		return aConfig;
	}

//	//-------------------------------------------------------------------------
//	private Config impl_configClusterMember4Localhost ()
//		throws Exception
//	{
//		final Config aConfig = new Config();
//
//		aConfig.setProperty("hazelcast.jmx.detailed"                 , "false");
//		aConfig.setProperty("hazelcast.jmx"                          , "false");
//		aConfig.setProperty("hazelcast.prefer.ipv4.stack"            , "true" );
//		aConfig.setProperty("hazelcast.executor.client.thread.count" , "20"   );
//		aConfig.setProperty("hazelcast.version.check.enabled"        , "false");
//		aConfig.setProperty("hazelcast.logging.type"                 , "slf4j");
//		aConfig.setProperty("hazelcast.immediate.backup.interval"    , "5"    );
//		aConfig.setProperty(GroupProperties.PROP_SHUTDOWNHOOK_ENABLED, "false");
//
//		final MapConfig aDefaultMapCfg = aConfig.getMapConfig("default");
//		aDefaultMapCfg.setBackupCount   (1   ); // synchronous backup to (at least) one other node within the cluster
//		aDefaultMapCfg.setReadBackupData(true);
//		
////		final MapConfig aCEServerMapCfg = aConfig.getMapConfig("ce-server-context");
////		aCEServerMapCfg.setBackupCount   (1   ); // synchronous backup to (at least) one other node within the cluster
////		aCEServerMapCfg.setReadBackupData(true);
//
//		final NearCacheConfig aDefaultMapCache = new NearCacheConfig();
//		aDefaultMapCache.setCacheLocalEntries(false);
//		aDefaultMapCfg.setNearCacheConfig(aDefaultMapCache);
//
//		final NetworkConfig    aNetwork   = aConfig .getNetworkConfig  ();
//		final GroupConfig      aGroup     = aConfig .getGroupConfig    ();
//		final JoinConfig       aJoin      = aNetwork.getJoin           ();
//		final MulticastConfig  aMulticast = aJoin   .getMulticastConfig();
//		final TcpIpConfig      aTcpIp     = aJoin   .getTcpIpConfig    ();
//		final AwsConfig        aAws       = aJoin   .getAwsConfig      ();
//		final InterfacesConfig aInterface = aNetwork.getInterfaces     ();
//		
//		aTcpIp    .setEnabled(true );
//		aAws      .setEnabled(false);
//		aMulticast.setEnabled(false);
//		aInterface.setEnabled(true );
//
//		aNetwork  .setPort             (8000);
//		aNetwork  .setPortAutoIncrement(true);
//		
//		aInterface.addInterface("127.0.0.1");
//
//		aGroup.setName    ("dev");
//		aGroup.setPassword("xxx");
//	
//		return aConfig;
//	}
//	
//	//-------------------------------------------------------------------------
//	private Config impl_configClusterMember4Multicast ()
//		throws Exception
//	{
//		final Config aConfig = new Config ();
//
//		// http://docs.hazelcast.org/docs/2.2/manual/html/ch12s06.html
//		aConfig.setProperty("hazelcast.jmx.detailed"                 , "false");
//		aConfig.setProperty("hazelcast.jmx"                          , "false");
//		aConfig.setProperty("hazelcast.prefer.ipv4.stack"            , "true" );
//		aConfig.setProperty("hazelcast.executor.client.thread.count" , "20"   );
//		aConfig.setProperty("hazelcast.version.check.enabled"        , "false");
//		aConfig.setProperty("hazelcast.logging.type"                 , "slf4j");
//		aConfig.setProperty("hazelcast.immediate.backup.interval"    , "5"    );
//		aConfig.setProperty(GroupProperties.PROP_SHUTDOWNHOOK_ENABLED, "false");
//		
//		final MapConfig aDefaultMapCfg = aConfig.getMapConfig("default");
//		aDefaultMapCfg.setBackupCount      (1   ); // synchronous backup to (at least) one other node within the cluster
//		aDefaultMapCfg.setReadBackupData   (true);
////		aDefaultMapCfg.setStatisticsEnabled(true);
//
//		final NearCacheConfig aDefaultMapCache = new NearCacheConfig();
//		aDefaultMapCache.setCacheLocalEntries(false);
//		aDefaultMapCfg.setNearCacheConfig(aDefaultMapCache);
//		
////		final MapConfig aCEServerMapCfg = aConfig.getMapConfig("ce-server-context");
////		aCEServerMapCfg.setBackupCount      (1   ); // synchronous backup to (at least) one other node within the cluster
////		aCEServerMapCfg.setReadBackupData   (true);
////		aCEServerMapCfg.setStatisticsEnabled(true);
////		
////		final NearCacheConfig aCEServerMapCache = new NearCacheConfig();
////		aCEServerMapCache.setCacheLocalEntries(false);
////		aDefaultMapCfg.setNearCacheConfig(aCEServerMapCache);
//		
//		final NetworkConfig    aNetwork   = aConfig .getNetworkConfig  ();
//		final GroupConfig      aGroup     = aConfig .getGroupConfig    ();
//		final JoinConfig       aJoin      = aNetwork.getJoin           ();
//		final MulticastConfig  aMulticast = aJoin   .getMulticastConfig();
//		final TcpIpConfig      aTcp       = aJoin   .getTcpIpConfig    ();
//		final AwsConfig        aAws       = aJoin   .getAwsConfig      ();
//		final InterfacesConfig aInterface = aNetwork.getInterfaces     ();
//		
//		aTcp      .setEnabled(false);
//		aAws      .setEnabled(false);
//		aMulticast.setEnabled(true );
//		
//		aNetwork  .setPort             (7000);
//		aNetwork  .setPortAutoIncrement(true);
//
//		aMulticast.setMulticastGroup("224.2.2.3");
//		aMulticast.setMulticastPort (54327      );
//		
//		aInterface.setEnabled  (true       );
//		aInterface.addInterface("127.0.0.1");
//		
//		aGroup.setName    ("dev");
//		aGroup.setPassword("xxx");
//
//		return aConfig;
//	}

	//-------------------------------------------------------------------------
	private HazelcastInstance m_aCore = null;

	//-------------------------------------------------------------------------
	private TransactionContext m_aTransaction = null;
	
	//-------------------------------------------------------------------------
	private String m_sScope = null;
}
