/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.cluster_management;

import org.apache.commons.lang3.Validate;

import ch.qos.logback.classic.BasicConfigurator;

import com.openxchange.office_communication.cluster_management.core.impl.ClusterConst;
import com.openxchange.office_communication.configuration.configitems.JmsServerConfig;
import com.openxchange.office_communication.configuration.configitems.LogProxyConfig;
import com.openxchange.office_communication.jms.core.camel.CamelUtils;
import com.openxchange.office_communication.jms.core.camel.ContextVariable;
import com.openxchange.office_communication.jms.core.camel.EmbeddedCamelContext;
import com.openxchange.office_communication.tools.logging.ELogLevel;
import com.openxchange.office_communication.tools.logging.LogProxyClient;
import com.openxchange.office_communication.tools.logging.LogUtils;
import com.openxchange.office_communication.tools.logging.v2.LogConst;
import com.openxchange.office_communication.tools.logging.v2.LogContext;
import com.openxchange.office_communication.tools.logging.v2.Logger;
import com.openxchange.office_communication.tools.logging.v2.Slf4JLogger;

//=============================================================================
public class ClusterManagementMain
{
	//-------------------------------------------------------------------------
	private ClusterManagementMain ()
		throws Exception
	{}
	
	//-------------------------------------------------------------------------
	public static void main(final String[] lArguments)
	{
		BasicConfigurator.configureDefaultContext();
		
		Logger LOG = null;
		try
		{
			final ClusterManagementCmdLine aCmdLine = new ClusterManagementCmdLine ();
			aCmdLine.parse(lArguments);
			
			if (aCmdLine.needsHelp())
			{
				aCmdLine.printHelp();
				return;
			}
			
			LogUtils.enablePIDLogging();
			LogUtils.enableAutoFlushOnShutdown();
	
			final LogProxyConfig aLogConf   = LogProxyConfig.access();
			final LogProxyClient aLogClient = new LogProxyClient ();
			aLogClient.setHost(aLogConf.getHost());
			aLogClient.setPort(aLogConf.getPort());
			aLogClient.start  ();
			                     
	                                   LOG            = Slf4JLogger.create(ClusterManagementMain.class);
			final LogContext           aLog           = LOG.inCategory ("CLUSTERMANAGER");
	
			final EmbeddedCamelContext aContext       = EmbeddedCamelContext.get ();
			final JmsServerConfig      aJmsServerCfg  = JmsServerConfig.access   ();
			
			final String               sJmsHost       = aJmsServerCfg.getHost();
			final String               sJmsPort       = aJmsServerCfg.getPortAsString();
			final String               sJmsImpl       = aJmsServerCfg.getConnectionFactory();
			
			final String               sContextRes    = "/res/context/cluster-manager-context.xml";

			aLog.forLevel   (ELogLevel.E_INFO  )
			    .withMessage(LogConst.CONFIGURE)
			    .log        ();
			
			Validate.notEmpty(sJmsHost   , "Miss configuration entry '"+JmsServerConfig.CFGKEY_SERVER_HOST              +"'.");
			Validate.notEmpty(sJmsPort   , "Miss configuration entry '"+JmsServerConfig.CFGKEY_SERVER_PORT              +"'.");
			Validate.notEmpty(sJmsImpl   , "Miss configuration entry '"+JmsServerConfig.CFGKEY_SERVER_CONNECTION_FACTORY+"'.");
	
			aContext.configure(CamelUtils.getAbsoluteResFileName(ClusterManagementMain.class, sContextRes));
	
			aContext.configure(ContextVariable.define(JmsServerConfig.CFGKEY_SERVER_HOST              , sJmsHost));
			aContext.configure(ContextVariable.define(JmsServerConfig.CFGKEY_SERVER_PORT              , sJmsPort));
			aContext.configure(ContextVariable.define(JmsServerConfig.CFGKEY_SERVER_CONNECTION_FACTORY, sJmsImpl));
			
			aContext.configure(ContextVariable.define("office.cluster-manager.queue.in", ClusterConst.QUEUE_4_REMOTE_CONTROL));
			
			if (aCmdLine.isUIEnabled())
				aContext.activateProfiles("profile-ui");
			
			aLog.forLevel   (ELogLevel.E_INFO)
			    .withMessage(LogConst.START  )
			    .log        ();
			aContext.start ();
			
			aLog.forLevel   (ELogLevel.E_INFO)
			    .withMessage(LogConst.WAIT   )
			    .log        ();
			aContext.join  ();

			aLog.forLevel   (ELogLevel.E_INFO)
			    .withMessage(LogConst.END    )
			    .log        ();
		}
		catch (final Throwable ex)
		{
			LogUtils.logErrorQuietly(LOG, ex);
		}
	}
}
