var allTestFiles = [];
var TEST_REGEXP = /(.*)\/spreadsheet\/(.*)(spec|test)\.js$/i;

Object.keys(window.__karma__.files).forEach(function(file) {
  if (TEST_REGEXP.test(file)) {
    // Normalize paths to RequireJS module names.
    allTestFiles.push(file);
  }
});

//FIXME: may be, this function should go somewhere else
//TODO: add jslob data that might be needed
(function () {
  var jslobIds = {
    'io.ox/office': {
      tree: {}
    }
  };
  var server = sinon.fakeServer.create();
  server.autoRespond = true;
  server.respondWith('PUT', /jslob/, function (xhr) {
    var ids = JSON.parse(xhr.requestBody),
        fakeSettings = {data: []};
    ids.forEach(function (id, index) {
      fakeSettings.data.push({
        id: id,
        meta: {},
        tree: _.has(jslobIds, id) ? jslobIds[id].tree : {}
      });
    });
    xhr.respond(200, {'Content-Type': 'text/javascript;charset=UTF-8'}, JSON.stringify(fakeSettings));
  });
}());

require.config({
  // Karma serves files under /base, which is the basePath from your config file
  baseUrl: '/base/apps',

  // dynamically load all test files
  deps: allTestFiles,

  // we have to kickoff jasmine, as it is asynchronous
  callback: window.__karma__.start
});