/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define(['io.ox/office/tk/forms'], function (Forms) {

    'use strict';

    describe('OX Documents Base Framework', function () {
        describe('Forms module', function () {

            it('should exist', function () {
                expect(Forms).to.be.an('object');
            });

            // constants ======================================================

            describe('constant "HIDDEN_CLASS"', function () {
                it('should exist', function () {
                    expect(Forms.HIDDEN_CLASS).to.be.a('string');
                    expect(Forms.HIDDEN_CLASS).to.not.be.empty;
                });
            });

            describe('constant "HIDDEN_SELECTOR"', function () {
                it('should exist', function () {
                    expect(Forms.HIDDEN_SELECTOR).to.be.a('string');
                    expect(Forms.HIDDEN_SELECTOR).to.not.be.empty;
                });
            });

            describe('constant "VISIBLE_SELECTOR"', function () {
                it('should exist', function () {
                    expect(Forms.VISIBLE_SELECTOR).to.be.a('string');
                    expect(Forms.VISIBLE_SELECTOR).to.not.be.empty;
                });
            });

            describe('constant "DISABLED_CLASS"', function () {
                it('should exist', function () {
                    expect(Forms.DISABLED_CLASS).to.be.a('string');
                    expect(Forms.DISABLED_CLASS).to.not.be.empty;
                });
            });

            describe('constant "DISABLED_SELECTOR"', function () {
                it('should exist', function () {
                    expect(Forms.DISABLED_SELECTOR).to.be.a('string');
                    expect(Forms.DISABLED_SELECTOR).to.not.be.empty;
                });
            });

            describe('constant "ENABLED_SELECTOR"', function () {
                it('should exist', function () {
                    expect(Forms.ENABLED_SELECTOR).to.be.a('string');
                    expect(Forms.ENABLED_SELECTOR).to.not.be.empty;
                });
            });

            describe('constant "SELECTED_CLASS"', function () {
                it('should exist', function () {
                    expect(Forms.SELECTED_CLASS).to.be.a('string');
                    expect(Forms.SELECTED_CLASS).to.not.be.empty;
                });
            });

            describe('constant "SELECTED_SELECTOR"', function () {
                it('should exist', function () {
                    expect(Forms.SELECTED_SELECTOR).to.be.a('string');
                    expect(Forms.SELECTED_SELECTOR).to.not.be.empty;
                });
            });

            describe('constant "FOCUSED_CLASS"', function () {
                it('should exist', function () {
                    expect(Forms.FOCUSED_CLASS).to.be.a('string');
                    expect(Forms.FOCUSED_CLASS).to.not.be.empty;
                });
            });

            describe('constant "FOCUSABLE_SELECTOR"', function () {
                it('should exist', function () {
                    expect(Forms.FOCUSABLE_SELECTOR).to.be.a('string');
                    expect(Forms.FOCUSABLE_SELECTOR).to.not.be.empty;
                });
            });

            describe('constant "BUTTON_CLASS"', function () {
                it('should exist', function () {
                    expect(Forms.BUTTON_CLASS).to.be.a('string');
                    expect(Forms.BUTTON_CLASS).to.not.be.empty;
                });
            });

            describe('constant "BUTTON_SELECTOR"', function () {
                it('should exist', function () {
                    expect(Forms.BUTTON_SELECTOR).to.be.a('string');
                    expect(Forms.BUTTON_SELECTOR).to.not.be.empty;
                });
            });

            // ----------------------------------------------------------------

        });
    });
});
