@echo off
rem
rem    This work is provided under the terms of the CREATIVE COMMONS PUBLIC
rem    LICENSE. This work is protected by copyright and/or other applicable
rem    law. Any use of the work other than as authorized under this license
rem    or copyright law is prohibited.
rem
rem    http://creativecommons.org/licenses/by-nc-sa/2.5/
rem
rem    © 2016 OX Software GmbH.
rem
rem     @author Daniel Rentz <daniel.rentz@open-xchange.com>
rem

setlocal

set CONVERT="%MAGICK_HOME%\convert"
set COMPOSITE="%MAGICK_HOME%\composite"

set OUT=build
set ICONSET_LESS=%OUT%\docs-icons.less
set ICONSET16_BLACK=%OUT%\docs-icons-desktop-black.png
set ICONSET16_WHITE=%OUT%\docs-icons-desktop-white.png
set ICONSET32_BLACK=%OUT%\docs-icons-retina-black.png
set ICONSET32_WHITE=%OUT%\docs-icons-retina-white.png

set SOURCE_SIZE=16
set LINE_SIZE=20

if not exist %OUT% mkdir %OUT%

rem generate the CSS file and count existing icons

echo preparing %ICONSET_LESS%
set /a ICON_SIZE=SOURCE_SIZE+2
type header.txt > %ICONSET_LESS%
echo .io-ox-office-main i[class^^="docs-"] { >> %ICONSET_LESS%
echo     width: %ICON_SIZE%px; >> %ICONSET_LESS%
echo     height: %ICON_SIZE%px; >> %ICONSET_LESS%
echo     ^&.docs-empty { background-position: 0 0; } >> %ICONSET_LESS%
echo reading icons.txt
set INDEX=1
for /f "tokens=1,* eol=#" %%A in (icons.txt) do call :write_css_classes "%%B"
if %INDEX% lss %LINE_SIZE% (set /a ICONSET_WIDTH=INDEX) else (set /a ICONSET_WIDTH=LINE_SIZE)
set /a ICONSET_HEIGHT=(INDEX-1)/LINE_SIZE+1
set /a ICONSET_WIDTH*=ICON_SIZE, ICONSET_HEIGHT*=ICON_SIZE
echo     background-size: %ICONSET_WIDTH%px %ICONSET_HEIGHT%px; >> %ICONSET_LESS%
echo } >> %ICONSET_LESS%

rem generate the icon sets

echo creating icon sets
%CONVERT% -size %ICONSET_WIDTH%x%ICONSET_HEIGHT% xc:none %ICONSET16_BLACK%
set /a ICONSET_WIDTH*=2, ICONSET_HEIGHT*=2
%CONVERT% -size %ICONSET_WIDTH%x%ICONSET_HEIGHT% xc:none %ICONSET32_BLACK%
set INDEX=1
for /f "tokens=1 eol=#" %%A in (icons.txt) do call :process_icon_file %%A
echo converting colors
%CONVERT% %ICONSET16_BLACK% -fuzz 100%% -fill #333333 -opaque #333333 %ICONSET16_BLACK%
%CONVERT% %ICONSET16_BLACK% -fuzz 100%% -fill #ffffff -opaque #ffffff %ICONSET16_WHITE%
%CONVERT% %ICONSET32_BLACK% -fuzz 100%% -fill #333333 -opaque #333333 %ICONSET32_BLACK%
%CONVERT% %ICONSET32_BLACK% -fuzz 100%% -fill #ffffff -opaque #ffffff %ICONSET32_WHITE%
echo done

endlocal
exit /b

:write_css_classes
setlocal
set /a POSX=-((INDEX%%LINE_SIZE)*ICON_SIZE)
set /a POSY=-((INDEX/LINE_SIZE)*ICON_SIZE)
for %%A in (%~1) do echo     ^&.docs-%%A { background-position: %POSX%px %POSY%px; } >> %ICONSET_LESS%
endlocal
set /a INDEX+=1
exit /b

:process_icon_file
setlocal
echo processing icon %1
set /a POSX=((INDEX%%LINE_SIZE)*ICON_SIZE+1), POSX2=(POSX*2)
set /a POSY=((INDEX/LINE_SIZE)*ICON_SIZE+1), POSY2=(POSY*2)
set FILENAME=%1
set FILENAME=%FILENAME:/=\%
set FILENAME16=images\%FILENAME%_16.png
set FILENAME32=images\%FILENAME%_32.png
%COMPOSITE% -geometry +%POSX%+%POSY% "%FILENAME16%" %ICONSET16_BLACK% %ICONSET16_BLACK%
%COMPOSITE% -geometry +%POSX2%+%POSY2% "%FILENAME32%" %ICONSET32_BLACK% %ICONSET32_BLACK%
endlocal
set /a INDEX+=1
exit /b
