/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/format/documentstyles',
    ['io.ox/office/editframework/model/documentstyles',
     'io.ox/office/text/format/characterstyles',
     'io.ox/office/text/format/paragraphstyles',
     'io.ox/office/text/format/drawingstyles',
     'io.ox/office/text/format/tablestyles',
     'io.ox/office/text/format/tablerowstyles',
     'io.ox/office/text/format/tablecellstyles',
     'io.ox/office/text/format/pagestyles',
     'io.ox/office/text/format/listcollection'
    ], function (DocumentStyles, CharacterStyles, ParagraphStyles, DrawingStyles, TableStyles, TableRowStyles, TableCellStyles, PageStyles, ListCollection) {

    'use strict';

    // definitions for document attributes ------------------------------------

    var TEXT_DOCUMENT_ATTRIBUTES = {

            defaultTabStop: 1270,   // default tab width: 0.5 inch

            zoom: { value: 100 },    // default zoom: 100%

            fileFormat: 'ooxml',

            changeTracking: false,

            changeTrackAuthors: []
        };

    // definitions for change tracking attributes -----------------------------

    var CHANGES_ATTRIBUTE_DEFINITIONS = {

            inserted: { def: '', scope: 'element' },

            removed: { def: '', scope: 'element' },

            modified: { def: '', scope: 'element' }
        };

    // class TextDocumentStyles ===============================================

    /**
     * Provides the style sheet containers for all attribute families used in a
     * text document, and other containers collecting special formatting
     * information for the text document.
     *
     * @constructor
     *
     * @extends DocumentStyles
     *
     * @param {TextApplication} app
     *  The root application instance.
     */
    function TextDocumentStyles(app) {

        // base constructor ---------------------------------------------------

        DocumentStyles.call(this, app, TEXT_DOCUMENT_ATTRIBUTES);

        // initialization -----------------------------------------------------

        this.registerAttributeDefinitions('changes', CHANGES_ATTRIBUTE_DEFINITIONS);

        this.addStyleCollection(new CharacterStyles(app, this))
            .addStyleCollection(new ParagraphStyles(app, this))
            .addStyleCollection(new DrawingStyles(app, this))
            .addStyleCollection(new TableStyles(app, this))
            .addStyleCollection(new TableRowStyles(app, this))
            .addStyleCollection(new TableCellStyles(app, this))
            .addStyleCollection(new PageStyles(app, this));

        this.addCustomCollection('lists', new ListCollection(app, this));

    } // class TextDocumentStyles

    // exports ================================================================

    // derive this class from class DocumentStyles
    return DocumentStyles.extend({ constructor: TextDocumentStyles });

});
