/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/settings/templatemodel', [
    'settings!io.ox/office'
], function (Settings) {

    'use strict';

    /**
     *
     * User-Model-Data
     * for Template folders
     * the folder-ids are saved in one array, and it is checked for double entries!
     *
     */
    function Model(key) {
        var self = this;

        /**
         * returns all template folder-ids in one array
         */
        this.getAll = function() {
            return Settings.get(key, []);
        };

        /**
         * adds the folder-id to the account,
         * double entries will be ignored and return false
         * new entries return true
         */
        this.add = function(folderId) {
            var list = self.getAll();
//            console.warn('lest before', list);
            var len = list.length;
            list.push(folderId);
            list = _.unique(list);
//            console.warn('lest after', list);
            Settings.set(key, list).save();

            return len !== list.length;
        };

        /**
         * tries to remove folder-id from the account data
         * if id is not in the list, false will be returned and no changes are saved
         * if deletion is successful, it is saved and returns true
         */
        this.remove = function(folderId) {
            var list = self.getAll();
            var index = list.indexOf(folderId);
            if (index<0) {
                return false;
            }
            list.splice(index, 1);
            Settings.set(key, list).save();
            return true;
        };
    }

    return Model;

});
