/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/preview/view/controls',
    ['io.ox/office/tk/utils',
     'io.ox/office/baseframework/view/basecontrols',
     'io.ox/office/preview/view/control/pagegroup',
     'gettext!io.ox/office/preview',
    ], function (Utils, BaseControls, PageGroup, gt) {

    'use strict';

    // static class PreviewControls ===========================================

    /**
     * Provides different classes for GUI form controls. Collects all standard
     * control group classes defined in the toolkit, and adds more controls
     * along with caption texts for control groups, menu headers, and other GUI
     * elements in a single map for convenience.
     *
     * @extends BaseControls
     */
    var PreviewControls = _.extend({}, BaseControls, {
        PageGroup: PageGroup
    });

    // class PageNumberField ==================================================

    /**
     * An input field for the current page number.
     *
     * @constructor
     *
     * @extends TextField
     */
    PreviewControls.PageNumberField = BaseControls.TextField.extend({ constructor: function (initOptions) {

        BaseControls.TextField.call(this, Utils.extendOptions({
            tooltip: gt('Page number'),
            width: 45,
            style: 'text-align:right;',
            keyboards: 'number'
        }, initOptions));

    }}); // class PageNumberField

    // exports ================================================================

    return PreviewControls;

});
