/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/preview/app/coreactions', ['io.ox/office/preview/app/actionshelper'], function (ActionsHelper) {

    'use strict';

    var // the identifier of the 'View' action
        ACTION_ID = 'io.ox/core/tk/attachment/actions/office/view';

    // global initialization ==================================================

    // create the action to view the file attachment in OX Viewer
    ActionsHelper.createViewerAction(ACTION_ID, 'module');

    // create a link in the attachment drop-down menu
    ActionsHelper.createViewerLink('io.ox/core/tk/attachments/links', ACTION_ID, { index: 100 });

    // disable 'Preview' and 'Open in browser' actions
    ActionsHelper.disableActionForViewable('io.ox/core/tk/attachment/actions/preview-attachment');
    ActionsHelper.disableActionForViewable('io.ox/core/tk/attachment/actions/open-attachment');

});
