/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/model/model',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/model/editmodel',
     'io.ox/office/editframework/model/undomanager',
     'io.ox/office/editframework/model/operationsgenerator',
     'io.ox/office/presentation/model/format/documentstyles'
    ], function (Utils, EditModel, UndoManager, OperationsGenerator, PresentationDocumentStyles) {

    'use strict';

    // class PresentationModel ================================================

    /**
     * Represents the document model of a presentation application.
     *
     * Triggers the events supported by the base class EditModel.
     *
     * @constructor
     *
     * @extends EditModel
     *
     * @param {PresentationApplication} app
     *  The application containing this document model.
     */
    function PresentationModel(app) {

        var // the undo manager of this document
            undoManager = new UndoManager(app),

            // container for all style sheets of all attribute families
            documentStyles = new PresentationDocumentStyles(app);

        // base constructor ---------------------------------------------------

        EditModel.call(this, app, OperationsGenerator, undoManager, documentStyles);

        // private methods ----------------------------------------------------

        // methods ------------------------------------------------------------

        // initialization -----------------------------------------------------

    } // class PresentationModel

    // exports ================================================================

    // derive this class from class EditModel
    return EditModel.extend({ constructor: PresentationModel });

});
