/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/model/format/documentstyles',
    ['io.ox/office/editframework/model/documentstyles'
    ], function (DocumentStyles) {

    'use strict';

    var // default values of presentation document attributes
        PRESENTATION_DOCUMENT_ATTRIBUTES = {};

    // class PresentationDocumentStyles =======================================

    /**
     * Provides the style sheet containers for all attribute families used in a
     * presentation document, and other containers collecting special
     * formatting information for the presentation document.
     *
     * @constructor
     *
     * @extends DocumentStyles
     *
     * @param {PresentationApplication} app
     *  The root application instance.
     */
    function PresentationDocumentStyles(app) {

        // base constructor ---------------------------------------------------

        DocumentStyles.call(this, app, PRESENTATION_DOCUMENT_ATTRIBUTES);

        // initialization -----------------------------------------------------

    } // class PresentationDocumentStyles

    // exports ================================================================

    // derive this class from class DocumentStyles
    return DocumentStyles.extend({ constructor: PresentationDocumentStyles });

});
