/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/view/templateview',
    ['gettext!io.ox/office/portal',
        'io.ox/office/portal/portalutils',
        'io.ox/core/extensions',
        'io.ox/office/portal/action/templateactions'
    ], function (gt, PortalUtils, Ext, TemplateActions) {

        'use strict';

        var templateView = Backbone.View.extend({

            tagName: 'div',

            className: 'office-portal-template',

            /**
             * Renders templates section of supported applications and 'My Templates' section
             *
             * @param {String} appBaseName
             *  The base name of the current application.
             *
             * @returns {templateView}
             */
            render: function (appBaseName) {

                // render nothing if we are on Text app on Android with non-supported Chrome or other browser
                if ((_.browser.Android) && (appBaseName === 'text') && !PortalUtils.supportedChromeVersionOnAndroidForText()) { return; }

                var self = this,
                    templateTypeWrapper = $('<div>').addClass('template-type-wrapper col-xs-12'),
                    templateWrapper = $('<div>').addClass('template-list f6-target');

                templateTypeWrapper.append(templateWrapper);

                self.$el.append(templateTypeWrapper);

                // draw create with blank template
                TemplateActions[appBaseName].invoke('draw', templateWrapper, Ext.Baton({ app : self.model }));

                // get right templates to render from template collection
                var userTemplates = this.collection.getTemplates(appBaseName, 'user'),
                    globalTemplates = this.collection.getTemplates(appBaseName, 'global');

                // render user templates for current active app type
                _.each(userTemplates, function (template) {
                    TemplateActions[appBaseName + 'user'].invoke('draw', templateWrapper, Ext.Baton({ data : template.attributes }));
                });

                // render global templates for active app type
                _.each(globalTemplates, function (template) {
                    TemplateActions[appBaseName + 'global'].invoke('draw', templateWrapper, Ext.Baton({ data : template.attributes }));
                });

                return this;
            }

        });

        return templateView;

    });
